/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.items.curios.belt;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.items.curios.GahGeoTrinketItem;
import com.dee12452.gahoodrpg.common.items.curios.IActionTrinket;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class CooldownBeltItem
extends GahGeoTrinketItem
implements IActionTrinket {
    protected final int cooldownTicks;

    public CooldownBeltItem(int cooldownTicks) {
        this.cooldownTicks = cooldownTicks;
    }

    public Optional<Cooldown> getCooldown(ItemStack stack) {
        return CooldownBeltCurio.getCooldown(stack);
    }

    @Override
    public void onTrinketActionPressed(Player player, ItemStack stack) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        Optional<Cooldown> cooldown = CooldownBeltCurio.getCooldown(stack);
        if (cooldown.isEmpty()) {
            return;
        }
        boolean offCooldown = cooldown.get().checkAndReset((LivingEntity)player);
        stack.m_41784_().m_128365_("gahCuriosCooldown", (Tag)cooldown.get().serializeNBT());
        if (!offCooldown) {
            return;
        }
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Sounds.BELT_ACTION.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        this.performAction(player, stack);
    }

    @Override
    @NotNull
    protected final ICurio createCurio(ItemStack stack, @Nullable CompoundTag nbt) {
        return this.createBeltCurio(stack, nbt);
    }

    protected CooldownBeltCurio createBeltCurio(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CooldownBeltCurio(stack);
    }

    protected abstract void performAction(Player var1, ItemStack var2);

    protected class CooldownBeltCurio
    implements ICurio {
        private final ItemStack stack;

        public CooldownBeltCurio(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void onEquip(SlotContext slotContext, ItemStack prevStack) {
            Optional<Cooldown> cooldown = CooldownBeltCurio.getCooldown(this.stack);
            if (cooldown.isPresent()) {
                return;
            }
            Cooldown newCooldown = new Cooldown(CooldownBeltItem.this.cooldownTicks);
            newCooldown.reset(slotContext.entity());
            this.stack.m_41784_().m_128365_("gahCuriosCooldown", (Tag)newCooldown.serializeNBT());
        }

        protected static Optional<Cooldown> getCooldown(ItemStack stack) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_("gahCuriosCooldown")) {
                Cooldown cooldown = new Cooldown();
                cooldown.deserializeNBT(tag.m_128469_("gahCuriosCooldown"));
                return Optional.of(cooldown);
            }
            return Optional.empty();
        }
    }
}

