/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.items.curios.belt;

import com.dee12452.gahoodrpg.common.items.curios.belt.CooldownBeltItem;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HomeboundBeltItem
extends CooldownBeltItem {
    private static final int COOLDOWN_TICKS = TimeUtils.secondsToTicks(180.0f);

    public HomeboundBeltItem() {
        super(COOLDOWN_TICKS);
    }

    @Override
    public String getId() {
        return "homebound_belt";
    }

    @Override
    public void performAction(Player player, ItemStack stack) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockPos respawnPosition = serverPlayer.m_8961_();
        if (respawnPosition == null) {
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.belt.no_home"), true);
            return;
        }
        float respawnRotation = serverPlayer.m_8962_();
        ServerLevel level = this.getOverworldLevel(serverPlayer);
        BlockState blockState = level.m_8055_(respawnPosition);
        Block respawnBlock = blockState.m_60734_();
        if (!(respawnBlock instanceof BedBlock) || !BedBlock.m_49488_((Level)level)) {
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.belt.cannot_send_home"), true);
            return;
        }
        Optional teleportPos = BedBlock.m_260958_((EntityType)EntityType.f_20532_, (CollisionGetter)level, (BlockPos)respawnPosition, (Direction)((Direction)blockState.m_61143_((Property)BedBlock.f_54117_)), (float)respawnRotation);
        if (teleportPos.isEmpty()) {
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.belt.cannot_send_home"), true);
            return;
        }
        serverPlayer.f_8906_.m_9774_(((Vec3)teleportPos.get()).f_82479_, ((Vec3)teleportPos.get()).f_82480_, ((Vec3)teleportPos.get()).f_82481_, respawnRotation, 0.0f);
    }

    private ServerLevel getOverworldLevel(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (WorldUtils.isOverworldDimension((Level)level)) {
            return level;
        }
        return WorldUtils.getOverworldLevel(player).orElseThrow();
    }
}

