/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.items.upgrades;

import com.dee12452.gahoodrpg.common.combat.GahAttributeModifiers;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.items.SimpleItem;
import com.dee12452.gahoodrpg.common.items.curios.GahTrinketItem;
import com.dee12452.gahoodrpg.utils.ColorUtils;
import com.dee12452.gahoodrpg.utils.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeItem
extends SimpleItem {
    private final GahStats additionalStats;

    public UpgradeItem(UpgradeApplicator applicator, int tier) {
        this.additionalStats = applicator.apply(new GahStats.Builder(), tier).build();
    }

    public GahStats getAdditionalStats() {
        return this.additionalStats;
    }

    public ItemStack createUpgradedCopy(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof GahTrinketItem) {
            GahTrinketItem trinket = (GahTrinketItem)item;
            ItemStack result = stack.m_41777_();
            trinket.injectAdditionalStats(result, this.getAdditionalStats());
            return result;
        }
        return ItemUtils.createCopyWithAddedStats(stack, ItemUtils.slotFromItem(stack).orElseThrow(), this.getAdditionalStats(), new ArrayList<Attribute>());
    }

    public void m_7373_(@NotNull ItemStack p_41421_, @Nullable Level p_41422_, @NotNull List<Component> tooltips, @NotNull TooltipFlag p_41424_) {
        GahAttributeModifiers.GAH_ATTRIBUTE_MODIFIERS.forEach((attribute, value) -> {
            float amount = value.getStatValue(this.additionalStats);
            if (amount <= 0.0f) {
                return;
            }
            TextColor color = ColorUtils.STAT_FORMATS.get(attribute);
            MutableComponent component = Component.m_237113_((String)("+" + String.valueOf(amount) + " ")).m_7220_((Component)Component.m_237115_((String)attribute.m_22087_()));
            tooltips.add((Component)component.m_130948_(component.m_7383_().m_131148_(color)));
        });
    }

    public static interface UpgradeApplicator {
        public GahStats.Builder apply(GahStats.Builder var1, float var2);
    }
}

