/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.loot;

import com.dee12452.gahoodrpg.common.loot.GahFishingLoot;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FishingLootModifier
extends LootModifier {
    public static final Codec<Map<String, List<GahFishingLoot>>> ROD_LOOT_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.list(GahFishingLoot.CODEC));
    public static final Codec<FishingLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ROD_LOOT_CODEC.fieldOf("rod_loot").forGetter(FishingLootModifier::getRodLoot)).apply((Applicative)inst, FishingLootModifier::new));
    private final Map<String, List<GahFishingLoot>> rodLoot;

    public FishingLootModifier(LootItemCondition[] conditionsIn, Map<String, List<GahFishingLoot>> rodLoot) {
        super(conditionsIn);
        this.rodLoot = rodLoot;
    }

    public Map<String, List<GahFishingLoot>> getRodLoot() {
        return this.rodLoot;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (!(entity instanceof Projectile)) {
            return generatedLoot;
        }
        Projectile hook = (Projectile)entity;
        Entity entity2 = hook.m_19749_();
        if (!(entity2 instanceof ServerPlayer)) {
            return generatedLoot;
        }
        ServerPlayer player = (ServerPlayer)entity2;
        ItemStack fishingRod = player.m_21120_(InteractionHand.MAIN_HAND);
        ResourceLocation itemResource = ForgeRegistries.ITEMS.getKey((Object)fishingRod.m_41720_());
        if (itemResource == null) {
            return generatedLoot;
        }
        String itemName = itemResource.toString();
        if (!this.rodLoot.containsKey(itemName)) {
            return generatedLoot;
        }
        List<GahFishingLoot> fishingLoot = this.rodLoot.get(itemName);
        BlockPos position = entity.m_20183_();
        ServerLevel level = context.m_78952_();
        List<GahFishingLoot> relevantLoot = fishingLoot.stream().filter(loot -> loot.biomes().stream().anyMatch(b -> WorldUtils.isBiome((Level)level, position, b))).filter(loot -> loot.resourceIds().contains(context.getQueriedLootTableId().toString())).toList();
        if (relevantLoot.isEmpty()) {
            return generatedLoot;
        }
        ObjectArrayList newLoot = new ObjectArrayList();
        for (GahFishingLoot loot2 : relevantLoot) {
            LootTable lootTable = context.m_278643_().m_278676_(new ResourceLocationBuilder(loot2.lootTableId()).named());
            LootContextParamSet lootContextParamSet = LootContextParamSet.m_165477_().m_81405_();
            LootParams lootParams = new LootParams.Builder(context.m_78952_()).m_287235_(lootContextParamSet);
            lootTable.m_287228_(lootParams, arg_0 -> ((ObjectArrayList)newLoot).add(arg_0));
        }
        return newLoot.isEmpty() ? generatedLoot : newLoot;
    }

    public Codec<FishingLootModifier> codec() {
        return CODEC;
    }
}

