/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.loot;

import com.dee12452.gahoodrpg.common.loot.AdditionalLoot;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class GlobalLootModifier
extends LootModifier {
    public static final Codec<GlobalLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.STRING.listOf().fieldOf("resource_ids").forGetter(GlobalLootModifier::getResourceIds), (App)AdditionalLoot.CODEC.listOf().fieldOf("additional_loot").forGetter(GlobalLootModifier::getAdditionalLoot))).apply((Applicative)inst, GlobalLootModifier::new));
    private final List<String> resourceIds;
    private final List<AdditionalLoot> additionalLoot;
    private final Set<String> resourceIdSet;

    public GlobalLootModifier(LootItemCondition[] conditionsIn, List<String> resourceIds, List<AdditionalLoot> additionalLoot) {
        super(conditionsIn);
        this.resourceIds = resourceIds;
        this.additionalLoot = additionalLoot;
        this.resourceIdSet = new HashSet<String>(resourceIds);
    }

    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public List<AdditionalLoot> getAdditionalLoot() {
        return this.additionalLoot;
    }

    public static <T extends LootModifier> Products.P1<RecordCodecBuilder.Mu<T>, LootItemCondition[]> baseCodec(RecordCodecBuilder.Instance<T> instance) {
        return LootModifier.codecStart(instance);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> items, LootContext lootContext) {
        if (this.resourceIdSet.contains(lootContext.getQueriedLootTableId().toString())) {
            List<ItemStack> additionalItems = this.additionalLoot.stream().map(al -> al.toItem(lootContext.m_230907_())).filter(stack -> !stack.m_41619_()).toList();
            items.addAll(additionalItems);
        }
        return items;
    }

    public Codec<GlobalLootModifier> codec() {
        return CODEC;
    }
}

