/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.menus;

import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityMenuBase
extends AbstractContainerMenu {
    protected final ContainerData metadata;
    private final int numCustomSlots;

    protected BlockEntityMenuBase(@Nullable MenuType<?> menuType, int containerId, Inventory inventory, int numCustomSlots, int numCustomDataSlots) {
        this(menuType, containerId, inventory, numCustomSlots, (Container)new SimpleContainer(numCustomSlots), (ContainerData)new SimpleContainerData(numCustomDataSlots));
    }

    protected BlockEntityMenuBase(@Nullable MenuType<?> menuType, int containerId, Inventory inventory, int numCustomSlots, Container container, ContainerData metadata) {
        super(menuType, containerId);
        this.numCustomSlots = numCustomSlots;
        this.metadata = metadata;
        this.addContainerSlots(container);
        this.addInventorySlots(inventory);
        this.m_38884_(metadata);
    }

    public void m_150399_(int slotIdx, int p_150401_, @NotNull ClickType clickType, @NotNull Player player) {
        if (this.isCraftResultSlot(slotIdx) && !this.m_38853_(slotIdx).m_6657_()) {
            return;
        }
        super.m_150399_(slotIdx, p_150401_, clickType, player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack1 = slot.m_7993_();
        ItemStack itemstack = itemstack1.m_41777_();
        if (slotIndex >= this.numCustomSlots) {
            if (!this.quickMoveToCustomSlot(slotIndex, itemstack1)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (!this.m_38903_(itemstack1, this.numCustomSlots, this.numCustomSlots + 36, true)) {
                return ItemStack.f_41583_;
            }
            if (this.isCraftResultSlot(slotIndex)) {
                slot.m_40234_(itemstack1, itemstack);
            }
        }
        if (itemstack1.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (itemstack1.m_41613_() == itemstack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, itemstack1);
        return itemstack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    public static Pair<Integer, Integer> calculateGridSlotCoordinates(int slotOffset, int columns, int x, int y) {
        int slotWidth = 18;
        int xOffset = slotOffset % columns * 18;
        int yOffset = slotOffset / columns * 18;
        return Pair.of((Object)(x + xOffset), (Object)(y + yOffset));
    }

    protected boolean moveItem(ItemStack item, int toSlot) {
        return this.m_38903_(item, toSlot, toSlot + 1, false);
    }

    protected boolean moveItem(ItemStack item, int minSlot, int maxSlot) {
        return this.m_38903_(item, minSlot, maxSlot + 1, false);
    }

    protected abstract Optional<Pair<Integer, Integer>> customSlotCoordinates(int var1);

    protected abstract boolean quickMoveToCustomSlot(int var1, ItemStack var2);

    protected abstract boolean isCraftResultSlot(int var1);

    protected void addInventorySlots(Inventory inventory) {
        this.addInventorySlots(inventory, 0, 0);
    }

    protected boolean shouldClearMenu(int slotIdx, @NotNull ClickType clickType) {
        boolean isResultSlot = this.isCraftResultSlot(slotIdx);
        boolean isResultGrab = isResultSlot && (clickType == ClickType.PICKUP || clickType == ClickType.QUICK_MOVE);
        return isResultGrab && this.m_38853_(slotIdx).m_6657_();
    }

    protected void addInventorySlots(Inventory inventory, int xOffset, int yOffset) {
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)inventory, i1 + k * 9 + 9, xOffset + 8 + i1 * 18, yOffset + 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)inventory, l, xOffset + 8 + l * 18, yOffset + 142));
        }
    }

    private void addContainerSlots(Container container) {
        for (int slotIdx = 0; slotIdx < this.numCustomSlots; ++slotIdx) {
            Optional<Pair<Integer, Integer>> slotCoords = this.customSlotCoordinates(slotIdx);
            if (slotCoords.isEmpty()) continue;
            this.m_38897_(new Slot(container, slotIdx, ((Integer)slotCoords.get().getLeft()).intValue(), ((Integer)slotCoords.get().getRight()).intValue()));
        }
    }
}

