/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.menus;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.common.menus.BlockEntityMenuBase;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientChangeScreen;
import com.dee12452.gahoodrpg.common.recipes.BossSpawnRecipe;
import com.dee12452.gahoodrpg.common.registries.MenuRegistry;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossSpawnTableMenu
extends BlockEntityMenuBase {
    public static final int NUM_CUSTOM_SLOTS = 4;
    @Nullable
    private final Player player;
    @Nullable
    private final Function<EntityType<?>, Boolean> bossConsumer;
    @Nullable
    private final BlockPos blockPos;

    public BossSpawnTableMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, (Container)new SimpleContainer(4), null, null, null);
    }

    public BossSpawnTableMenu(int containerId, Inventory inventory, Container container, @Nullable Player player, @Nullable Function<EntityType<?>, Boolean> bossConsumer, @Nullable BlockPos blockPos) {
        super((MenuType)MenuRegistry.BOSS_SPAWN_TABLE_MENU_TYPE.get(), containerId, inventory, 4, container, (ContainerData)new SimpleContainerData(0));
        this.player = player;
        this.bossConsumer = bossConsumer;
        this.blockPos = blockPos;
        this.addListeners();
    }

    @Override
    protected Optional<Pair<Integer, Integer>> customSlotCoordinates(int slotIndex) {
        if (slotIndex < 4) {
            return Optional.of(BossSpawnTableMenu.calculateGridSlotCoordinates(slotIndex, 2, 74, 18));
        }
        return Optional.empty();
    }

    @Override
    protected boolean quickMoveToCustomSlot(int originalSlotIndex, ItemStack stack) {
        if (originalSlotIndex <= 4) {
            return true;
        }
        return this.moveItem(this.m_38853_(originalSlotIndex).m_7993_(), 0, 4);
    }

    @Override
    protected boolean isCraftResultSlot(int slotIndex) {
        return false;
    }

    private void addListeners() {
        this.m_38893_(new ContainerListener(){

            public void m_7934_(@NotNull AbstractContainerMenu menu, int index, @NotNull ItemStack stack) {
                Player player = BossSpawnTableMenu.this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (BossSpawnTableMenu.this.checkSpawnBoss(menu)) {
                        BossSpawnTableMenu.this.useIngredients();
                        NetworkChannel.sendToClient(serverPlayer, new ClientChangeScreen.Message(GahoodRPGClient.ScreenType.NONE));
                    }
                }
            }

            public void m_142153_(@NotNull AbstractContainerMenu p_150524_, int p_150525_, int p_150526_) {
            }
        });
    }

    private boolean checkSpawnBoss(AbstractContainerMenu menu) {
        Optional<MinecraftServer> server = Optional.ofNullable(this.player).map(Entity::m_20194_);
        if (server.isEmpty() || this.bossConsumer == null) {
            return false;
        }
        RecipeManager recipeManager = server.get().m_129894_();
        TransientCraftingContainer craftingContainer = new TransientCraftingContainer(menu, 2, 2);
        for (int idx = 0; idx < 4; ++idx) {
            craftingContainer.m_6836_(idx, this.m_38853_(idx).m_7993_());
        }
        Optional recipe = recipeManager.m_44015_(BossSpawnRecipe.RECIPE_TYPE, (Container)craftingContainer, this.player.m_9236_());
        if (recipe.isEmpty()) {
            return false;
        }
        return this.bossConsumer.apply(((BossSpawnRecipe)((Object)recipe.get())).getBoss().get());
    }

    private void useIngredients() {
        if (this.player == null || this.blockPos == null) {
            return;
        }
        Level level = this.player.m_9236_();
        for (int idx = 0; idx < 4; ++idx) {
            ItemStack itemStack = this.m_38853_(idx).m_7993_();
            if (itemStack.m_41619_()) continue;
            this.m_38853_(idx).m_5852_(ItemStack.f_41583_);
            itemStack.m_41764_(itemStack.m_41613_() - 1);
            if (itemStack.m_41619_()) continue;
            Block.m_49840_((Level)level, (BlockPos)this.blockPos, (ItemStack)itemStack);
        }
    }
}

