/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.menus;

import com.dee12452.gahoodrpg.common.items.ForgeFuel;
import com.dee12452.gahoodrpg.common.menus.BlockEntityMenuBase;
import com.dee12452.gahoodrpg.common.registries.MenuRegistry;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ForgingStationMenu
extends BlockEntityMenuBase {
    public static final int NUM_CUSTOM_SLOTS = 6;
    public static final int NUM_DATA_SLOTS = 5;
    public static final int FUEL_SLOT = 4;
    public static final int RESULT_SLOT = 5;

    public ForgingStationMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(5));
    }

    public ForgingStationMenu(int containerId, Inventory inventory, Container container, ContainerData containerData) {
        super((MenuType)MenuRegistry.FORGING_STATION_MENU_TYPE.get(), containerId, inventory, 6, container, containerData);
    }

    public int getData(int dataSlotIdx) {
        return this.metadata.m_6413_(dataSlotIdx);
    }

    @Override
    protected Optional<Pair<Integer, Integer>> customSlotCoordinates(int slotIndex) {
        if (slotIndex < 4) {
            return Optional.of(ForgingStationMenu.calculateGridSlotCoordinates(slotIndex, 2, 56, 21));
        }
        if (slotIndex == 4) {
            return Optional.of(Pair.of((Object)105, (Object)63));
        }
        if (slotIndex == 5) {
            return Optional.of(Pair.of((Object)138, (Object)26));
        }
        return Optional.empty();
    }

    @Override
    protected boolean quickMoveToCustomSlot(int originalSlotIndex, ItemStack stack) {
        ItemStack slotItem = this.m_38853_(originalSlotIndex).m_7993_();
        if (originalSlotIndex <= 5) {
            return true;
        }
        if (ForgingStationMenu.isFuel(slotItem) && !this.m_38853_(4).m_6657_()) {
            return this.moveItem(slotItem, 4);
        }
        return this.moveItem(slotItem, 0, 3);
    }

    @Override
    protected boolean isCraftResultSlot(int slotIndex) {
        return slotIndex == 5;
    }

    public static boolean isFuel(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof ForgeFuel;
    }
}

