/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.menus;

import com.dee12452.gahoodrpg.common.items.upgrades.UpgradeItem;
import com.dee12452.gahoodrpg.common.menus.BlockEntityMenuBase;
import com.dee12452.gahoodrpg.common.recipes.GahCraftingStationRecipe;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GahCraftingStationMenu<T extends GahCraftingStationRecipe>
extends BlockEntityMenuBase {
    public static final int CUSTOM_SLOTS = 45;
    public static final int CRAFTING_ROWS = 4;
    public static final int CRAFTING_COLS = 4;
    private static final int CUSTOM_DATA_SLOTS = 0;
    private static final int RESULT_SLOT_IDX = 16;
    private static final int UPGRADE_SLOT_IDX = 17;
    private final RecipeType<T> recipeType;
    private final ServerPlayer player;
    private final int craftRows;
    private final int craftColumns;

    public GahCraftingStationMenu(MenuType<? extends GahCraftingStationMenu<?>> menuType, RecipeType<T> recipeType, int containerId, Inventory inventory) {
        this(menuType, recipeType, containerId, inventory, (Container)new SimpleContainer(45), null);
    }

    public GahCraftingStationMenu(MenuType<? extends GahCraftingStationMenu<?>> menuType, RecipeType<T> recipeType, int containerId, Inventory inventory, Container container, @Nullable Player player) {
        super(menuType, containerId, inventory, 45, container, (ContainerData)new SimpleContainerData(0));
        this.recipeType = recipeType;
        this.player = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        this.craftRows = 4;
        this.craftColumns = 4;
        this.addListeners();
    }

    @Override
    public void m_150399_(int slotIdx, int p_150401_, @NotNull ClickType clickType, @NotNull Player player) {
        if (this.isCraftResultSlot(slotIdx) && !this.m_38853_(slotIdx).m_6657_()) {
            return;
        }
        boolean shouldClearGrid = this.shouldClearMenu(slotIdx, clickType);
        super.m_150399_(slotIdx, p_150401_, clickType, player);
        if (!shouldClearGrid) {
            return;
        }
        for (int craftSlotIdx = 0; craftSlotIdx < this.craftRows * this.craftColumns; ++craftSlotIdx) {
            this.m_38853_(craftSlotIdx).m_6201_(1);
        }
        if (this.m_38853_(17).m_6657_()) {
            this.m_38853_(17).m_6201_(1);
        }
        this.m_38853_(16).m_5852_(ItemStack.f_41583_);
    }

    @Override
    protected Optional<Pair<Integer, Integer>> customSlotCoordinates(int slotIndex) {
        Object slotCoords = slotIndex < 16 ? GahCraftingStationMenu.calculateGridSlotCoordinates(slotIndex, 4, 93, 17) : (slotIndex == 16 ? Pair.of((Object)213, (Object)45) : (slotIndex == 17 ? Pair.of((Object)182, (Object)19) : GahCraftingStationMenu.calculateGridSlotCoordinates(slotIndex - 18, 3, 14, 11)));
        return Optional.of(slotCoords);
    }

    @Override
    protected boolean quickMoveToCustomSlot(int originalSlotIndex, ItemStack stack) {
        return this.moveItem(stack, 18, 44);
    }

    @Override
    protected boolean isCraftResultSlot(int slotIndex) {
        return slotIndex == 16;
    }

    @Override
    protected void addInventorySlots(Inventory inventory) {
        super.addInventorySlots(inventory, 80, 18);
    }

    private void checkCraftRecipe(@NotNull AbstractContainerMenu menu, int slotIdx) {
        this.m_38853_(16).m_5852_(ItemStack.f_41583_);
        Optional<ItemStack> craftingResult = this.craftFromRecipe(menu);
        craftingResult.ifPresent(itemStack -> this.m_38853_(16).m_5852_(itemStack));
    }

    private void addListeners() {
        this.m_38893_(new ContainerListener(){

            public void m_7934_(@NotNull AbstractContainerMenu menu, int slotIdx, @NotNull ItemStack itemStack) {
                if (slotIdx >= 16 && slotIdx != 17) {
                    return;
                }
                GahCraftingStationMenu.this.checkCraftRecipe(menu, slotIdx);
            }

            public void m_142153_(@NotNull AbstractContainerMenu wbMenu, int dataSlotIdx, int data) {
            }
        });
    }

    private Optional<ItemStack> craftFromRecipe(AbstractContainerMenu menu) {
        Optional<MinecraftServer> server = Optional.ofNullable(this.player).map(Entity::m_20194_);
        if (server.isEmpty()) {
            return Optional.empty();
        }
        RecipeManager recipeManager = server.get().m_129894_();
        TransientCraftingContainer craftingContainer = new TransientCraftingContainer(menu, 4, 4);
        for (int idx = 0; idx < 16; ++idx) {
            craftingContainer.m_6836_(idx, this.m_38853_(idx).m_7993_());
        }
        Optional recipe = recipeManager.m_44015_(this.recipeType, (Container)craftingContainer, this.player.m_9236_());
        if (recipe.isEmpty()) {
            return Optional.empty();
        }
        GahCraftingStationRecipe customCraftingRecipe = (GahCraftingStationRecipe)((Object)recipe.get());
        ItemStack resultStack = customCraftingRecipe.m_8043_((RegistryAccess)server.get().m_206579_()).m_41777_();
        ItemStack modifierItem = this.m_38853_(17).m_7993_();
        if (!customCraftingRecipe.isUpgradable()) {
            if (modifierItem.m_41619_()) {
                return Optional.of(resultStack);
            }
            return Optional.empty();
        }
        return Optional.of(this.addUpgrade(resultStack, modifierItem)).filter(stack -> !stack.m_41619_());
    }

    private ItemStack addUpgrade(ItemStack result, ItemStack upgrade) {
        Item item;
        if (upgrade.m_41619_() || !((item = upgrade.m_41720_()) instanceof UpgradeItem)) {
            return ItemStack.f_41583_;
        }
        UpgradeItem upgradeItem = (UpgradeItem)item;
        return upgradeItem.createUpgradedCopy(result);
    }
}

