/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.menus;

import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.items.Items;
import com.dee12452.gahoodrpg.common.items.weapons.IGahGeoWeapon;
import com.dee12452.gahoodrpg.common.menus.BlockEntityMenuBase;
import com.dee12452.gahoodrpg.common.registries.MenuRegistry;
import com.dee12452.gahoodrpg.utils.ItemUtils;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class StatInjectionStationMenu
extends BlockEntityMenuBase {
    public static final int NUM_CUSTOM_SLOTS = 3;
    public static final int INPUT_SLOT = 0;
    public static final int INJECTION_SLOT = 1;
    public static final int RESULT_SLOT = 2;

    public StatInjectionStationMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, (Container)new SimpleContainer(3));
    }

    public StatInjectionStationMenu(int containerId, Inventory inventory, Container container) {
        super((MenuType)MenuRegistry.STAT_INJECTION_STATION_MENU_TYPE.get(), containerId, inventory, 3, container, (ContainerData)new SimpleContainerData(0));
        this.addListeners();
    }

    @Override
    public void m_150399_(int slotIdx, int p_150401_, @NotNull ClickType clickType, @NotNull Player player) {
        boolean shouldClearGrid = this.shouldClearMenu(slotIdx, clickType);
        super.m_150399_(slotIdx, p_150401_, clickType, player);
        if (!shouldClearGrid) {
            return;
        }
        this.m_38853_(0).m_6201_(1);
        this.m_38853_(1).m_6201_(1);
        this.m_38853_(2).m_5852_(ItemStack.f_41583_);
    }

    @Override
    protected Optional<Pair<Integer, Integer>> customSlotCoordinates(int slotIndex) {
        if (slotIndex == 1) {
            return Optional.of(Pair.of((Object)85, (Object)54));
        }
        if (slotIndex == 2) {
            return Optional.of(Pair.of((Object)138, (Object)26));
        }
        return Optional.of(Pair.of((Object)34, (Object)27));
    }

    @Override
    protected boolean quickMoveToCustomSlot(int originalSlotIndex, ItemStack stack) {
        ItemStack slotItem = this.m_38853_(originalSlotIndex).m_7993_();
        if (StatInjectionStationMenu.isInjector(slotItem) && !this.m_38853_(1).m_6657_()) {
            return this.moveItem(slotItem, 1);
        }
        if (StatInjectionStationMenu.isInjectable(slotItem) && !this.m_38853_(0).m_6657_()) {
            return this.moveItem(slotItem, 0);
        }
        return false;
    }

    @Override
    protected boolean isCraftResultSlot(int slotIndex) {
        return slotIndex == 2;
    }

    private void addListeners() {
        this.m_38893_(new ContainerListener(){

            public void m_7934_(@NotNull AbstractContainerMenu menu, int index, @NotNull ItemStack stack) {
                if (index > 2) {
                    return;
                }
                StatInjectionStationMenu.this.m_38853_(2).m_5852_(ItemStack.f_41583_);
                if (!StatInjectionStationMenu.this.m_38853_(1).m_6657_() || !StatInjectionStationMenu.this.m_38853_(0).m_6657_()) {
                    return;
                }
                ItemStack injectorStack = StatInjectionStationMenu.this.m_38853_(1).m_7993_();
                ItemStack inputStack = StatInjectionStationMenu.this.m_38853_(0).m_7993_();
                if (!StatInjectionStationMenu.isInjector(injectorStack) || !StatInjectionStationMenu.isInjectable(inputStack)) {
                    return;
                }
                ItemStack result = injectorStack.m_41720_() == Items.STAT_INJECTOR_EMPTY.get() ? StatInjectionStationMenu.createInjectorResult(inputStack) : StatInjectionStationMenu.createStatInjectedResult(inputStack, injectorStack);
                StatInjectionStationMenu.this.m_38853_(2).m_5852_(result);
            }

            public void m_142153_(@NotNull AbstractContainerMenu p_150524_, int p_150525_, int p_150526_) {
            }
        });
    }

    private static ItemStack createInjectorResult(ItemStack inputStack) {
        GahStats statsToInject = ItemUtils.extractItemStats(inputStack);
        Optional<EquipmentSlot> slot = ItemUtils.slotFromItem(inputStack);
        if (statsToInject.equals(GahStats.EMPTY) || slot.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack output = new ItemStack((ItemLike)Items.STAT_INJECTOR.get());
        output = ItemUtils.createCopyWithSetStats(output, slot.get(), statsToInject);
        ItemUtils.setStackSlot(output, slot.get());
        return output;
    }

    private static ItemStack createStatInjectedResult(ItemStack inputStack, ItemStack injectorStack) {
        GahStats statsToInject = ItemUtils.extractItemStats(injectorStack);
        CompoundTag injectorTag = injectorStack.m_41783_();
        if (statsToInject.equals(GahStats.EMPTY) || injectorTag == null) {
            return ItemStack.f_41583_;
        }
        EquipmentSlot injectorSlot = EquipmentSlot.values()[injectorTag.m_128451_("statSlot")];
        Optional<EquipmentSlot> inputSlot = ItemUtils.slotFromItem(inputStack);
        if (inputSlot.isEmpty() || injectorSlot != inputSlot.get()) {
            return ItemStack.f_41583_;
        }
        return ItemUtils.createCopyWithSetStats(inputStack, injectorSlot, statsToInject);
    }

    private static boolean isInjector(ItemStack stack) {
        Item item = stack.m_41720_();
        return item == Items.STAT_INJECTOR.get() || item == Items.STAT_INJECTOR_EMPTY.get();
    }

    private static boolean isInjectable(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof ArmorItem || item instanceof IGahGeoWeapon;
    }
}

