/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.ServerPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.GahRoles;
import com.dee12452.gahoodrpg.common.capabilities.spell.GahSpells;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientChangeRole;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientRoleSync;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSpellSync;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSyncOptions;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSyncSwapItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;

public class ClientSync {
    private final ServerPlayer player;
    private final List<INetworkMessage> messages = new ArrayList<INetworkMessage>();

    private ClientSync(ServerPlayer player) {
        this.player = player;
    }

    public void sync() {
        this.messages.forEach(msg -> NetworkChannel.sendToClient(this.player, msg));
    }

    public static class Builder {
        private final ClientSync clientSync;

        public Builder(ServerPlayer player) {
            this.clientSync = new ClientSync(player);
        }

        public ClientSync all() {
            return this.roles().spells().swapData().configData().build();
        }

        public Builder roles() {
            CommonPlayerCapability cap = Capabilities.commonPlayer((Player)this.clientSync.player);
            this.clientSync.messages.add(new ClientChangeRole.Message(cap.getCurrentRoleId().orElse(null)));
            List<UUID> roleIds = GahRoles.getRoles().stream().map(Pair::getKey).toList();
            for (UUID roleId : roleIds) {
                this.clientSync.messages.add(new ClientRoleSync.Message(roleId, cap.getRole(roleId).orElseThrow().serializeNBT()));
            }
            return this;
        }

        public Builder spells() {
            CommonPlayerCapability cap = Capabilities.commonPlayer((Player)this.clientSync.player);
            List<UUID> spellIds = GahSpells.getSpells().stream().map(Pair::getKey).toList();
            for (UUID spellId : spellIds) {
                this.clientSync.messages.add(new ClientSpellSync.Message(spellId, (CompoundTag)cap.getSpell(spellId).serializeNBT()));
            }
            return this;
        }

        public Builder swapData() {
            CommonPlayerCapability playerCapability = Capabilities.commonPlayer((Player)this.clientSync.player);
            this.clientSync.messages.add(new ClientSyncSwapItem.Message(playerCapability.getMainHandSwapItemId(), playerCapability.getOffHandSwapItemId()));
            return this;
        }

        public Builder configData() {
            ServerPlayerCapability playerCapability = Capabilities.serverPlayer(this.clientSync.player);
            this.clientSync.messages.add(new ClientSyncOptions.Message(playerCapability.isPvpEnabled()));
            return this;
        }

        public ClientSync build() {
            return this.clientSync;
        }
    }
}

