/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network;

import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkChannel {
    private static final String CURRENT_PROTOCOL_VERSION = "1.0";
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("gahoodrpg", "network_channel");
    private final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)RESOURCE_LOCATION, () -> "1.0", "1.0"::equals, "1.0"::equals);
    private static NetworkChannel instance;

    private NetworkChannel() {
    }

    public static NetworkChannel getInstance() {
        if (instance == null) {
            instance = new NetworkChannel();
        }
        return instance;
    }

    public static void sendToServer(INetworkMessage message) {
        NetworkChannel.getInstance().channel.send(PacketDistributor.SERVER.noArg(), (Object)message);
    }

    public static void sendToClient(ServerPlayer player, INetworkMessage message) {
        NetworkChannel.getInstance().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public static void sendToClients(List<ServerPlayer> players, INetworkMessage message) {
        players.forEach(player -> NetworkChannel.sendToClient(player, message));
    }

    public static void sendToAllClients(INetworkMessage message) {
        NetworkChannel.getInstance().channel.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    public static void sendToClientsInLevel(ServerLevel level, INetworkMessage message) {
        ResourceKey dimension = Optional.of(level).map(Level::m_46472_).orElseThrow();
        NetworkChannel.getInstance().channel.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)message);
    }

    public SimpleChannel getChannel() {
        return this.channel;
    }
}

