/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.client;

import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientNetworkEncoder;
import com.google.common.collect.Lists;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class ClientEntityTransform
implements ClientNetworkEncoder<Message> {
    @Override
    public void encode(Message message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.serializeNBT());
    }

    @Override
    public Message decode(FriendlyByteBuf buffer) {
        Message message = new Message();
        CompoundTag messageNBT = Optional.ofNullable(buffer.m_130260_()).orElseThrow();
        message.deserializeNBT(messageNBT);
        return message;
    }

    @Override
    public Class<Message> getMessageClass() {
        return Message.class;
    }

    @Override
    public void onClientProcess(Player clientPlayer, Message message) {
        int entityId = message.getEntityId();
        Entity entity = clientPlayer.m_9236_().m_6815_(entityId);
        if (entity == null) {
            return;
        }
        Optional.ofNullable(message.getLocation()).ifPresent(arg_0 -> ((Entity)entity).m_20219_(arg_0));
        Optional.ofNullable(message.getDeltaSpeed()).ifPresent(arg_0 -> ((Entity)entity).m_20256_(arg_0));
        Optional.ofNullable(message.getXRot()).ifPresent(arg_0 -> ((Entity)entity).m_146926_(arg_0));
        Optional.ofNullable(message.getYRot()).ifPresent(arg_0 -> ((Entity)entity).m_146922_(arg_0));
        Optional.ofNullable(message.getHeadYRot()).ifPresent(arg_0 -> ((Entity)entity).m_5616_(arg_0));
        if (message.swing && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    public static class Message
    implements INBTSerializable<CompoundTag>,
    INetworkMessage {
        private int entityId = 0;
        @Nullable
        private Vec3 location;
        @Nullable
        private Vec3 deltaSpeed;
        @Nullable
        private Float yRot;
        @Nullable
        private Float headYRot;
        @Nullable
        private Float xRot;
        private boolean swing = false;

        public int getEntityId() {
            return this.entityId;
        }

        @Nullable
        public Vec3 getLocation() {
            return this.location;
        }

        @Nullable
        public Vec3 getDeltaSpeed() {
            return this.deltaSpeed;
        }

        @Nullable
        public Float getYRot() {
            return this.yRot;
        }

        @Nullable
        public Float getHeadYRot() {
            return this.headYRot;
        }

        @Nullable
        public Float getXRot() {
            return this.xRot;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("entityId", this.entityId);
            this.putVec3(nbt, "location", this.location);
            this.putVec3(nbt, "deltaSpeed", this.deltaSpeed);
            if (this.xRot != null) {
                nbt.m_128350_("xRot", this.xRot.floatValue());
            }
            if (this.yRot != null) {
                nbt.m_128350_("yRot", this.yRot.floatValue());
            }
            if (this.headYRot != null) {
                nbt.m_128350_("headYRot", this.headYRot.floatValue());
            }
            nbt.m_128379_("swing", this.swing);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.entityId = nbt.m_128451_("entityId");
            this.location = this.extractVec3(nbt, "location");
            this.deltaSpeed = this.extractVec3(nbt, "deltaSpeed");
            if (nbt.m_128441_("xRot")) {
                this.xRot = Float.valueOf(nbt.m_128457_("xRot"));
            }
            if (nbt.m_128441_("yRot")) {
                this.yRot = Float.valueOf(nbt.m_128457_("yRot"));
            }
            if (nbt.m_128441_("headYRot")) {
                this.headYRot = Float.valueOf(nbt.m_128457_("headYRot"));
            }
            this.swing = nbt.m_128471_("swing");
        }

        private void putVec3(CompoundTag nbt, String key, @Nullable Vec3 vec3) {
            if (vec3 == null) {
                return;
            }
            nbt.m_128347_(String.format("%sX", key), vec3.f_82479_);
            nbt.m_128347_(String.format("%sY", key), vec3.f_82480_);
            nbt.m_128347_(String.format("%sZ", key), vec3.f_82481_);
        }

        @Nullable
        private Vec3 extractVec3(CompoundTag nbt, String key) {
            String keyX = String.format("%sX", key);
            String keyY = String.format("%sY", key);
            String keyZ = String.format("%sZ", key);
            if (Lists.newArrayList((Object[])new String[]{keyX, keyY, keyZ}).stream().allMatch(arg_0 -> ((CompoundTag)nbt).m_128441_(arg_0))) {
                return new Vec3(nbt.m_128459_(keyX), nbt.m_128459_(keyY), nbt.m_128459_(keyZ));
            }
            return null;
        }

        public static class Builder {
            private final Message message = new Message();

            public Builder(int entityId) {
                this.message.entityId = entityId;
            }

            public Builder location(Vec3 loc) {
                this.message.location = loc;
                return this;
            }

            public Builder deltaMovement(Vec3 deltaMovement) {
                this.message.deltaSpeed = deltaMovement;
                return this;
            }

            public Builder xRot(float xRot) {
                this.message.xRot = Float.valueOf(xRot);
                return this;
            }

            public Builder yRot(float yRot) {
                this.message.yRot = Float.valueOf(yRot);
                return this;
            }

            public Builder headYRot(float headYRot) {
                this.message.headYRot = Float.valueOf(headYRot);
                return this;
            }

            public Builder swing() {
                this.message.swing = true;
                return this;
            }

            public Message build() {
                return this.message;
            }
        }
    }
}

