/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.client;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkEncoder;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public interface ClientNetworkEncoder<T extends INetworkMessage>
extends INetworkEncoder<T> {
    @Override
    default public NetworkDirection getDirection() {
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    default public void onMessage(T message, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            throw new IllegalCallerException("Tried to send a client network message to the server");
        }
        context.get().setPacketHandled(true);
        Player player = Optional.ofNullable(GahoodRPGClient.getInstance().getClientPlayer()).orElseThrow();
        this.onClientProcess(player, message);
    }

    public void onClientProcess(Player var1, T var2);
}

