/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.client;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientNetworkEncoder;
import java.util.Optional;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class ClientStopSound
implements ClientNetworkEncoder<Message> {
    @Override
    public void encode(Message message, FriendlyByteBuf buffer) {
        message.sound().m_263231_(buffer);
        buffer.writeInt(message.source().ordinal());
    }

    @Override
    public Message decode(FriendlyByteBuf buffer) {
        SoundEvent sound = SoundEvent.m_263214_((FriendlyByteBuf)buffer);
        SoundSource source = SoundSource.values()[buffer.readInt()];
        return new Message(sound, source);
    }

    @Override
    public Class<Message> getMessageClass() {
        return Message.class;
    }

    @Override
    public void onClientProcess(Player clientPlayer, Message message) {
        Optional<SoundManager> soundManager = Optional.ofNullable(GahoodRPGClient.getInstance().getSoundManager());
        if (soundManager.isEmpty()) {
            return;
        }
        ResourceLocation soundLocation = message.sound().m_11660_();
        if (soundLocation.equals((Object)SoundEvents.f_271165_.m_11660_())) {
            soundManager.get().m_120405_();
        } else {
            soundManager.get().m_120386_(soundLocation, message.source());
        }
    }

    public record Message(SoundEvent sound, SoundSource source) implements INetworkMessage
    {
    }
}

