/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.client;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientNetworkEncoder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class ClientSyncSwapItem
implements ClientNetworkEncoder<Message> {
    @Override
    public void encode(Message message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.mainHandSwapItem());
        buffer.writeInt(message.offHandSwapItem());
    }

    @Override
    public Message decode(FriendlyByteBuf buffer) {
        int mainHandSwapSlot = buffer.readInt();
        int offHandSwapSlot = buffer.readInt();
        return new Message(mainHandSwapSlot, offHandSwapSlot);
    }

    @Override
    public Class<Message> getMessageClass() {
        return Message.class;
    }

    @Override
    public void onClientProcess(Player clientPlayer, Message message) {
        CommonPlayerCapability playerCapability = Capabilities.commonPlayer(clientPlayer);
        playerCapability.setMainHandSwapItemId(message.mainHandSwapItem());
        playerCapability.setOffHandSwapItemId(message.offHandSwapItem());
    }

    public record Message(int mainHandSwapItem, int offHandSwapItem) implements INetworkMessage
    {
    }
}

