/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.server;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.network.ClientSync;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerNetworkEncoder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerChangeRole
implements ServerNetworkEncoder<Message> {
    @Override
    public void encode(Message message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.roleId());
    }

    @Override
    public Message decode(FriendlyByteBuf buffer) {
        UUID newRole = buffer.m_130259_();
        return new Message(newRole);
    }

    @Override
    public Class<Message> getMessageClass() {
        return Message.class;
    }

    @Override
    public void onServerProcess(ServerPlayer player, Message message) {
        CommonPlayerCapability cap = Capabilities.commonPlayer((Player)player);
        Optional<IGahRole> currentRole = cap.getCurrentRole();
        currentRole.ifPresent(role -> role.getAllSpells((Player)player).forEach(spell -> spell.onDisable((Player)player)));
        cap.setRole(message.roleId());
        cap.getRole(message.roleId()).orElseThrow().getAllSpells((Player)player).forEach(spell -> spell.onEnable((Player)player));
        new ClientSync.Builder(player).roles().build().sync();
    }

    public record Message(UUID roleId) implements INetworkMessage
    {
    }
}

