/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.server;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSpellSync;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerNetworkEncoder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerClearSpellPoints
implements ServerNetworkEncoder<Message> {
    @Override
    public void encode(Message message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.role());
    }

    @Override
    public Message decode(FriendlyByteBuf buffer) {
        UUID newRole = buffer.m_130259_();
        return new Message(newRole);
    }

    @Override
    public Class<Message> getMessageClass() {
        return Message.class;
    }

    @Override
    public void onServerProcess(ServerPlayer player, Message message) {
        CommonPlayerCapability cap = Capabilities.commonPlayer((Player)player);
        Optional<IGahRole> role = cap.getRole(message.role());
        if (role.isEmpty()) {
            return;
        }
        List<UUID> primarySpellIds = role.get().getPrimarySpellIds();
        for (UUID spellId : primarySpellIds) {
            ILevelingGahSpell spell = (ILevelingGahSpell)cap.getSpell(spellId);
            spell.setSpellPoints(0);
            NetworkChannel.sendToClient(player, new ClientSpellSync.Message(spellId, spell.serializeNBT()));
        }
    }

    public record Message(UUID role) implements INetworkMessage
    {
    }
}

