/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.server;

import com.dee12452.gahoodrpg.common.entities.living.IGahMob;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerNetworkEncoder;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ServerEnterBossRoom
implements ServerNetworkEncoder<Message> {
    @Override
    public void encode(Message message, FriendlyByteBuf buffer) {
    }

    @Override
    public Message decode(FriendlyByteBuf buffer) {
        return new Message();
    }

    @Override
    public Class<Message> getMessageClass() {
        return Message.class;
    }

    @Override
    public void onServerProcess(ServerPlayer player, Message message) {
        if (this.canEnterBossRoom(player)) {
            EntityUtils.sendPlayerToBossRoom(player);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.masterybook.prevent_boss_room_entrance"), true);
        }
    }

    private boolean canEnterBossRoom(ServerPlayer player) {
        ServerLevel bossRoomLevel = WorldUtils.getBossRoomLevel(player).orElseThrow();
        for (Entity entity : bossRoomLevel.m_142646_().m_142273_()) {
            IGahMob gahMob;
            if (!(entity instanceof IGahMob) || !(gahMob = (IGahMob)entity).isBoss()) continue;
            return false;
        }
        return true;
    }

    public static class Message
    implements INetworkMessage {
    }
}

