/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.server;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSpellSync;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerNetworkEncoder;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerIncrementSpellPoint
implements ServerNetworkEncoder<Message> {
    @Override
    public void encode(Message message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.spellId());
    }

    @Override
    public Message decode(FriendlyByteBuf buffer) {
        UUID spell = buffer.m_130259_();
        return new Message(spell);
    }

    @Override
    public Class<Message> getMessageClass() {
        return Message.class;
    }

    @Override
    public void onServerProcess(ServerPlayer player, Message message) {
        CommonPlayerCapability capability = Capabilities.commonPlayer((Player)player);
        ILevelingGahSpell spell = (ILevelingGahSpell)capability.getSpell(message.spellId());
        spell.setSpellPoints(spell.getSpellPoints() + 1);
        NetworkChannel.sendToClient(player, new ClientSpellSync.Message(message.spellId(), spell.serializeNBT()));
    }

    public record Message(UUID spellId) implements INetworkMessage
    {
    }
}

