/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.server;

import com.dee12452.gahoodrpg.common.combat.InventorySwapper;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientInventorySwap;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerNetworkEncoder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerInventorySwap
implements ServerNetworkEncoder<Message> {
    @Override
    public void encode(Message message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.mainHandItemId());
        buffer.writeInt(message.offHandItemId());
    }

    @Override
    public Message decode(FriendlyByteBuf buffer) {
        int mainHandItemId = buffer.readInt();
        int offHandItemId = buffer.readInt();
        return new Message(mainHandItemId, offHandItemId);
    }

    @Override
    public Class<Message> getMessageClass() {
        return Message.class;
    }

    @Override
    public void onServerProcess(ServerPlayer player, Message message) {
        new InventorySwapper((Player)player).swapHolding(message.mainHandItemId(), message.offHandItemId());
        NetworkChannel.sendToClient(player, new ClientInventorySwap.Message(message.mainHandItemId(), message.offHandItemId()));
    }

    public record Message(int mainHandItemId, int offHandItemId) implements INetworkMessage
    {
    }
}

