/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.server;

import com.dee12452.gahoodrpg.common.network.encoders.INetworkEncoder;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public interface ServerNetworkEncoder<T extends INetworkMessage>
extends INetworkEncoder<T> {
    @Override
    default public NetworkDirection getDirection() {
        return NetworkDirection.PLAY_TO_SERVER;
    }

    @Override
    default public void onMessage(T message, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            throw new IllegalCallerException("Tried to send a server network message to the client");
        }
        context.get().setPacketHandled(true);
        this.onServerProcess(context.get().getSender(), message);
    }

    public void onServerProcess(ServerPlayer var1, T var2);
}

