/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.network.encoders.server;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerNetworkEncoder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerReleaseSpell
implements ServerNetworkEncoder<Message> {
    @Override
    public void encode(Message message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.spell());
    }

    @Override
    public Message decode(FriendlyByteBuf buffer) {
        UUID spell = buffer.m_130259_();
        return new Message(spell);
    }

    @Override
    public Class<Message> getMessageClass() {
        return Message.class;
    }

    @Override
    public void onServerProcess(ServerPlayer player, Message message) {
        CommonPlayerCapability cap = Capabilities.commonPlayer((Player)player);
        Optional<IGahRole> role = cap.getCurrentRole();
        if (role.isEmpty()) {
            return;
        }
        if (!role.get().hasSpell(message.spell())) {
            return;
        }
        IGahSpell spell = cap.getSpell(message.spell());
        if (spell.canUse() && !player.m_5833_()) {
            spell.onReleaseSpell((Player)player);
        }
    }

    public record Message(UUID spell) implements INetworkMessage
    {
    }
}

