/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BossSpawnRecipe
extends ShapelessRecipe {
    public static final RecipeType<BossSpawnRecipe> RECIPE_TYPE = new RecipeType<BossSpawnRecipe>(){};
    public static final Serializer SERIALIZER = new Serializer();
    private final Supplier<EntityType<?>> boss;

    public BossSpawnRecipe(ResourceLocation id, String group, NonNullList<Ingredient> ingredients, Supplier<EntityType<?>> boss) {
        super(id, group, CraftingBookCategory.MISC, ItemStack.f_41583_, ingredients);
        this.boss = boss;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public Supplier<EntityType<?>> getBoss() {
        return this.boss;
    }

    public static class Serializer
    implements RecipeSerializer<BossSpawnRecipe> {
        public BossSpawnRecipe fromJson(ResourceLocation p_44290_, JsonObject p_44291_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44291_, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)p_44291_, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)p_44291_, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 4) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is 4");
            }
            String boss = GsonHelper.m_13906_((JsonObject)p_44291_, (String)"boss");
            ResourceLocation bossResourceLocation = new ResourceLocation(boss);
            Holder.Reference delegate = (Holder.Reference)ForgeRegistries.ENTITY_TYPES.getDelegate(bossResourceLocation).orElseThrow();
            return new BossSpawnRecipe(p_44290_, s, nonnulllist, (Supplier<EntityType<?>>)delegate);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray p_44276_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_44276_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)p_44276_.get(i));
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public BossSpawnRecipe fromNetwork(@NotNull ResourceLocation p_44293_, FriendlyByteBuf buf) {
            String s = buf.m_130277_();
            int i = buf.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ResourceLocation bossResourceLocation = buf.m_130281_();
            Holder.Reference delegate = (Holder.Reference)ForgeRegistries.ENTITY_TYPES.getDelegate(bossResourceLocation).orElseThrow();
            return new BossSpawnRecipe(p_44293_, s, (NonNullList<Ingredient>)nonnulllist, (Supplier<EntityType<?>>)delegate);
        }

        public void toNetwork(FriendlyByteBuf buf, BossSpawnRecipe recipe) {
            buf.m_130070_(recipe.m_6076_());
            buf.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            ResourceKey key = (ResourceKey)ForgeRegistries.ENTITY_TYPES.getResourceKey(recipe.getBoss().get()).orElseThrow();
            buf.m_130085_(key.m_135782_());
        }
    }
}

