/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.recipes;

import com.dee12452.gahoodrpg.common.items.Items;
import com.dee12452.gahoodrpg.common.menus.ForgingStationMenu;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgingStationRecipe
extends ShapelessRecipe {
    public static final net.minecraft.world.item.crafting.RecipeType<ForgingStationRecipe> RECIPE_TYPE = new net.minecraft.world.item.crafting.RecipeType<ForgingStationRecipe>(){};
    public static final Serializer SERIALIZER = new Serializer();
    private final ItemStack directResult;
    private final Ingredient fuel;

    public ForgingStationRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> ingredients, Ingredient fuel) {
        super(id, group, CraftingBookCategory.MISC, result, ingredients);
        this.directResult = result;
        this.fuel = fuel;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @NotNull
    public net.minecraft.world.item.crafting.RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public Ingredient getFuelIngredient() {
        return this.fuel;
    }

    public static class Serializer
    implements RecipeSerializer<ForgingStationRecipe> {
        @NotNull
        public ForgingStationRecipe fromJson(@NotNull ResourceLocation p_44290_, @NotNull JsonObject p_44291_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44291_, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)p_44291_, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 4) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is 4");
            }
            Ingredient fuelIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_44291_, (String)"fuel"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_44291_, (String)"result"));
            return new ForgingStationRecipe(p_44290_, s, itemstack, nonnulllist, fuelIngredient);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray p_44276_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_44276_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)p_44276_.get(i));
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public ForgingStationRecipe fromNetwork(@NotNull ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            String s = buf.m_130277_();
            int i = buf.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            Ingredient fuelIngredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack itemstack = buf.m_130267_();
            return new ForgingStationRecipe(resourceLocation, s, itemstack, (NonNullList<Ingredient>)nonnulllist, fuelIngredient);
        }

        public void toNetwork(FriendlyByteBuf buf, ForgingStationRecipe recipe) {
            buf.m_130070_(recipe.m_6076_());
            buf.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            recipe.getFuelIngredient().m_43923_(buf);
            buf.m_130055_(recipe.directResult);
        }
    }

    public static class Category
    implements IRecipeCategory<ForgingStationRecipe> {
        public static final RecipeType<ForgingStationRecipe> RECIPE_TYPE = new RecipeType(new ResourceLocationBuilder("forging_station_recipe_type").named(), ForgingStationRecipe.class);
        private static final ResourceLocation TEXTURE = new ResourceLocationBuilder("jei/forging_station").gui();
        private final IDrawable background;
        private final IDrawable icon;
        @Nullable
        private final Level level;

        public Category(IGuiHelper guiHelper, @Nullable Level level) {
            this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 148, 100).setTextureSize(148, 148).build();
            ItemStack iconStack = new ItemStack((ItemLike)Items.FORGING_STATION.get());
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconStack);
            this.level = level;
        }

        public @NotNull RecipeType<ForgingStationRecipe> getRecipeType() {
            return RECIPE_TYPE;
        }

        @NotNull
        public Component getTitle() {
            return Component.m_237115_((String)"menu.gahoodrpg.forging_station.name");
        }

        @NotNull
        public IDrawable getBackground() {
            return this.background;
        }

        @NotNull
        public IDrawable getIcon() {
            return this.icon;
        }

        public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ForgingStationRecipe recipe, @NotNull IFocusGroup focuses) {
            Optional<RegistryAccess> registryAccess = WorldUtils.getRegistryAccess(this.level);
            if (registryAccess.isEmpty()) {
                return;
            }
            builder.setShapeless();
            NonNullList ingredients = recipe.m_7527_();
            int slotIdx = 0;
            boolean done = false;
            block0: for (int r = 0; r < 2 && !done; ++r) {
                for (int c = 0; c < 2; ++c) {
                    if (slotIdx >= ingredients.size()) {
                        done = true;
                        continue block0;
                    }
                    Pair<Integer, Integer> coords = ForgingStationMenu.calculateGridSlotCoordinates(slotIdx, 2, 28, 21);
                    builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)coords.getLeft()).intValue(), ((Integer)coords.getRight()).intValue()).addIngredients((Ingredient)ingredients.get(slotIdx));
                    ++slotIdx;
                }
            }
            builder.addSlot(RecipeIngredientRole.CATALYST, 77, 63).addItemStack(recipe.fuel.m_43908_()[0]);
            ItemStack result = recipe.m_8043_(registryAccess.get());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 110, 26).addItemStack(result);
        }
    }
}

