/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.recipes;

import com.dee12452.gahoodrpg.common.items.upgrades.UpgradeItem;
import com.dee12452.gahoodrpg.common.items.upgrades.Upgrades;
import com.dee12452.gahoodrpg.common.menus.GahCraftingStationMenu;
import com.dee12452.gahoodrpg.utils.RecipeUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GahCraftingStationRecipe
extends ShapedRecipe {
    public static final int MAX_WIDTH = 4;
    public static final int MAX_HEIGHT = 4;
    private final ItemStack result;
    private final boolean upgradable;
    private final int level;

    public GahCraftingStationRecipe(ResourceLocation id, String p_272759_, int p_272952_, int p_272920_, NonNullList<Ingredient> p_273650_, ItemStack result, boolean upgradable, int level) {
        super(id, p_272759_, CraftingBookCategory.MISC, p_272952_, p_272920_, p_273650_, result, false);
        this.result = result;
        this.upgradable = upgradable;
        this.level = level;
    }

    ItemStack getDirectResult() {
        return this.result;
    }

    public boolean isUpgradable() {
        return this.upgradable;
    }

    public int getLevel() {
        return this.level;
    }

    public static abstract class Category<T extends GahCraftingStationRecipe>
    implements IRecipeCategory<T> {
        private static final ResourceLocation TEXTURE = new ResourceLocationBuilder("jei/gah_crafting_station").gui();
        private final RecipeType<T> recipeType;
        private final String menuName;
        private final IDrawable background;
        private final IDrawable icon;
        @Nullable
        private final Level level;

        public Category(RecipeType<T> recipeType, String menuName, Item craftingTableItem, IGuiHelper guiHelper, @Nullable Level level) {
            this.recipeType = recipeType;
            this.menuName = menuName;
            this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 176, 100).setTextureSize(176, 176).build();
            ItemStack iconStack = new ItemStack((ItemLike)craftingTableItem);
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconStack);
            this.level = level;
        }

        public @NotNull RecipeType<T> getRecipeType() {
            return this.recipeType;
        }

        @NotNull
        public Component getTitle() {
            return Component.m_237115_((String)this.menuName);
        }

        @NotNull
        public IDrawable getBackground() {
            return this.background;
        }

        @NotNull
        public IDrawable getIcon() {
            return this.icon;
        }

        public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull T recipe, @NotNull IFocusGroup focuses) {
            Optional<RegistryAccess> registryAccess = WorldUtils.getRegistryAccess(this.level);
            if (registryAccess.isEmpty()) {
                return;
            }
            NonNullList ingredients = recipe.m_7527_();
            int slotIdx = 0;
            block0: for (int r = 0; r < 4; ++r) {
                for (int c = 0; c < 4; ++c) {
                    Pair<Integer, Integer> slotLoc = GahCraftingStationMenu.calculateGridSlotCoordinates(slotIdx, 4, 13, 17);
                    if (slotIdx >= ingredients.size()) {
                        builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)slotLoc.getLeft()).intValue(), ((Integer)slotLoc.getRight()).intValue());
                        continue block0;
                    }
                    builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)slotLoc.getLeft()).intValue(), ((Integer)slotLoc.getRight()).intValue()).addIngredients((Ingredient)ingredients.get(slotIdx));
                    ++slotIdx;
                }
            }
            ItemStack result = recipe.m_8043_(registryAccess.get());
            if (!((GahCraftingStationRecipe)((Object)recipe)).isUpgradable()) {
                builder.addSlot(RecipeIngredientRole.OUTPUT, 133, 45).addItemStack(result);
                return;
            }
            List<ItemStack> upgrades = Upgrades.getAll().stream().map(ItemStack::new).toList();
            builder.addSlot(RecipeIngredientRole.INPUT, 102, 19).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, upgrades);
            List<ItemStack> possibleResults = upgrades.stream().map(upgrade -> (UpgradeItem)upgrade.m_41720_()).map(upgrade -> upgrade.createUpgradedCopy(result)).toList();
            builder.addSlot(RecipeIngredientRole.OUTPUT, 133, 45).addItemStacks(possibleResults);
        }
    }

    public static abstract class Serializer<T extends GahCraftingStationRecipe>
    extends ShapedRecipe.Serializer {
        @NotNull
        public final T fromJson(@NotNull ResourceLocation resourceLocation, @NotNull JsonObject jsonObject) {
            String s = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            Map<String, Ingredient> map = RecipeUtils.keyFromJson(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"key"));
            String[] astring = RecipeUtils.shrink(RecipeUtils.patternFromJson(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = RecipeUtils.dissolvePattern(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            boolean upgradable = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"upgradable", (boolean)true);
            int level = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"level", (int)0);
            return this.createRecipe(resourceLocation, s, i, j, nonnulllist, itemstack, upgradable, level);
        }

        @Nullable
        public T fromNetwork(@NotNull ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            int i = buf.m_130242_();
            int j = buf.m_130242_();
            String s = buf.m_130277_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack itemstack = buf.m_130267_();
            boolean upgradable = buf.readBoolean();
            int level = buf.readInt();
            return this.createRecipe(resourceLocation, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack, upgradable, level);
        }

        public final void m_6178_(FriendlyByteBuf buf, ShapedRecipe recipe) {
            buf.m_130130_(recipe.m_44220_());
            buf.m_130130_(recipe.m_44221_());
            buf.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            if (!(recipe instanceof GahCraftingStationRecipe)) {
                throw new IllegalStateException("Bad recipe type sent to network");
            }
            GahCraftingStationRecipe customCraftingStationRecipe = (GahCraftingStationRecipe)recipe;
            buf.m_130055_(customCraftingStationRecipe.getDirectResult());
            buf.writeBoolean(customCraftingStationRecipe.isUpgradable());
            buf.writeInt(customCraftingStationRecipe.getLevel());
        }

        protected abstract T createRecipe(ResourceLocation var1, String var2, int var3, int var4, NonNullList<Ingredient> var5, ItemStack var6, boolean var7, int var8);
    }
}

