/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.recipes;

import com.dee12452.gahoodrpg.common.items.Items;
import com.google.common.collect.Lists;
import java.util.List;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class GahPotionRecipe
implements IBrewingRecipe {
    private static final List<Pair<Item, Item>> RESULTS = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)((Item)Items.RAGE_ESSENCE.get()), (Object)((Item)Items.GAH_EXPERIENCE_POTION_TIER_1.get())), Pair.of((Object)((Item)Items.PYRAMID_STONE.get()), (Object)((Item)Items.GAH_EXPERIENCE_POTION_TIER_2.get())), Pair.of((Object)((Item)Items.RUNESTONE.get()), (Object)((Item)Items.GAH_EXPERIENCE_POTION_TIER_3.get()))});

    public boolean isInput(@NotNull ItemStack itemStack) {
        return GahPotionRecipe.isMundanePotion(itemStack);
    }

    public boolean isIngredient(@NotNull ItemStack itemStack) {
        return RESULTS.stream().anyMatch(r -> r.getKey() == itemStack.m_41720_());
    }

    @NotNull
    public ItemStack getOutput(@NotNull ItemStack input, @NotNull ItemStack ingredient) {
        if (!GahPotionRecipe.isMundanePotion(input)) {
            return ItemStack.f_41583_;
        }
        return RESULTS.stream().filter(r -> r.getKey() == ingredient.m_41720_()).map(Pair::getValue).findFirst().map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    public static List<IJeiBrewingRecipe> getJeiRecipes() {
        return RESULTS.stream().map(JeiRecipe::new).map(r -> r).toList();
    }

    private static boolean isMundanePotion(ItemStack stack) {
        return PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43600_;
    }

    private static ItemStack mundanePotion() {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42589_), (Potion)Potions.f_43600_);
    }

    public record JeiRecipe(Pair<Item, Item> recipe) implements IJeiBrewingRecipe
    {
        public @Unmodifiable @NotNull List<ItemStack> getPotionInputs() {
            return Lists.newArrayList((Object[])new ItemStack[]{GahPotionRecipe.mundanePotion()});
        }

        public @Unmodifiable @NotNull List<ItemStack> getIngredients() {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this.recipe.getKey())});
        }

        @NotNull
        public ItemStack getPotionOutput() {
            return new ItemStack((ItemLike)this.recipe.getValue());
        }

        public int getBrewingSteps() {
            return 0;
        }
    }
}

