/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.recipes;

import com.dee12452.gahoodrpg.common.recipes.ForgingStationRecipe;
import com.dee12452.gahoodrpg.common.recipes.GahArmorCraftingStationRecipe;
import com.dee12452.gahoodrpg.common.recipes.GahPotionRecipe;
import com.dee12452.gahoodrpg.common.recipes.GahTrinketCraftingStationRecipe;
import com.dee12452.gahoodrpg.common.recipes.GahWeaponCraftingStationRecipe;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.google.common.collect.Lists;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JeiModPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocationBuilder("gahoodrpg_jei_plugin").named();
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        Optional<RecipeManager> recipeManager = Optional.ofNullable(Minecraft.m_91087_().f_91073_).map(ClientLevel::m_7465_);
        if (recipeManager.isEmpty()) {
            return;
        }
        registration.addRecipes(RecipeTypes.BREWING, GahPotionRecipe.getJeiRecipes());
        this.registerAllRecipes(registration, recipeManager.get(), ForgingStationRecipe.Category.RECIPE_TYPE, ForgingStationRecipe.RECIPE_TYPE);
        this.registerAllRecipes(registration, recipeManager.get(), GahWeaponCraftingStationRecipe.Category.RECIPE_TYPE, GahWeaponCraftingStationRecipe.RECIPE_TYPE);
        this.registerAllRecipes(registration, recipeManager.get(), GahArmorCraftingStationRecipe.Category.RECIPE_TYPE, GahArmorCraftingStationRecipe.RECIPE_TYPE);
        this.registerAllRecipes(registration, recipeManager.get(), GahTrinketCraftingStationRecipe.Category.RECIPE_TYPE, GahTrinketCraftingStationRecipe.RECIPE_TYPE);
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        if (level == null) {
            return;
        }
        Lists.newArrayList((Object[])new IRecipeCategory[]{new ForgingStationRecipe.Category(guiHelper, (Level)level), new GahWeaponCraftingStationRecipe.Category(guiHelper, (Level)level), new GahArmorCraftingStationRecipe.Category(guiHelper, (Level)level), new GahTrinketCraftingStationRecipe.Category(guiHelper, (Level)level)}).forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    private <C extends CraftingContainer, T extends Recipe<C>> void registerAllRecipes(IRecipeRegistration registration, RecipeManager recipeManager, RecipeType<T> jeiType, net.minecraft.world.item.crafting.RecipeType<T> vanillaType) {
        registration.addRecipes(jeiType, recipeManager.m_44013_(vanillaType));
    }
}

