/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.registries;

import com.dee12452.gahoodrpg.common.recipes.BossSpawnRecipe;
import com.dee12452.gahoodrpg.common.recipes.ForgingStationRecipe;
import com.dee12452.gahoodrpg.common.recipes.GahArmorCraftingStationRecipe;
import com.dee12452.gahoodrpg.common.recipes.GahPotionRecipe;
import com.dee12452.gahoodrpg.common.recipes.GahTrinketCraftingStationRecipe;
import com.dee12452.gahoodrpg.common.recipes.GahWeaponCraftingStationRecipe;
import com.dee12452.gahoodrpg.common.registries.IRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeRegistry
implements IRegistry {
    public static final int RECIPE_MAX_WIDTH = 4;
    public static final int RECIPE_MAX_HEIGHT = 4;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"gahoodrpg");
    private static final List<Pair<String, RecipeSerializer<?>>> SERIALIZERS_TO_REGISTER = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"forging_station", (Object)ForgingStationRecipe.SERIALIZER), Pair.of((Object)"boss_spawn", (Object)BossSpawnRecipe.SERIALIZER), Pair.of((Object)"gah_weapon_crafting_station", (Object)((Object)GahWeaponCraftingStationRecipe.SERIALIZER)), Pair.of((Object)"gah_armor_crafting_station", (Object)((Object)GahArmorCraftingStationRecipe.SERIALIZER)), Pair.of((Object)"gah_trinket_crafting_station", (Object)((Object)GahTrinketCraftingStationRecipe.SERIALIZER))});
    private final IEventBus eventBus;

    public RecipeRegistry(IEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public void register() {
        ShapedRecipe.setCraftingSize((int)4, (int)4);
        SERIALIZERS_TO_REGISTER.forEach(serializer -> RECIPE_SERIALIZERS.register((String)serializer.getLeft(), () -> ((Pair)serializer).getRight()));
        RECIPE_SERIALIZERS.register(this.eventBus);
    }

    public static void registerPotions() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new GahPotionRecipe());
    }
}

