/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.utils;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientEntityTransform;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class EntityUtils {
    public static final float DEFAULT_MAX_HEALTH = (float)Attributes.f_22276_.m_22082_();

    private EntityUtils() {
    }

    public static float toHealth(float hearts) {
        return hearts * 2.0f;
    }

    public static float getTieredHealth(int tier) {
        return (DEFAULT_MAX_HEALTH + EntityUtils.toHealth(2.0f)) * (float)tier;
    }

    public static float getTieredBossHealth(int tier) {
        return EntityUtils.getTieredHealth(tier) * 15.0f;
    }

    public static Optional<LivingEntity> raytraceLivingEntity(LivingEntity viewer, double maxDistance) {
        return EntityUtils.legacyRaytraceEntitiesInView(viewer, maxDistance).stream().filter(e -> e instanceof LivingEntity).filter(e -> EntityUtils.isLookingAt(viewer, e, 0.03)).map(e -> (LivingEntity)e).findFirst();
    }

    @Deprecated
    public static List<Entity> legacyRaytraceEntitiesInView(LivingEntity viewer, double maxDistance) {
        Vec3 viewVector = viewer.m_20252_(1.0f);
        AABB viewBox = viewer.m_20191_().m_82369_(viewVector.m_82490_(maxDistance)).m_82377_(1.0, 1.0, 1.0);
        return viewer.m_9236_().m_45933_((Entity)viewer, viewBox);
    }

    public static List<Entity> raytraceEntitiesInView(LivingEntity viewer, double maxDistance) {
        Vec3 viewVector = viewer.m_20154_();
        AABB box = new AABB(viewer.m_20185_() - 0.1, viewer.m_20188_() - 0.1, viewer.m_20189_() - 0.1, viewer.m_20185_() + 0.1, viewer.m_20188_() + 0.1, viewer.m_20189_() + 0.1);
        List viableEntities = viewer.m_9236_().m_45933_((Entity)viewer, viewer.m_20191_().m_82400_(Math.ceil(maxDistance) * 2.0));
        AABB viewBox = box.m_82369_(viewVector.m_82490_(maxDistance));
        return viableEntities.stream().filter(e -> e.m_20191_().m_82381_(viewBox)).sorted(Comparator.comparingDouble(arg_0 -> ((LivingEntity)viewer).m_20270_(arg_0))).toList();
    }

    public static Vec3 getAngleFrom(float yRot, float xRot) {
        double yaw = Math.toRadians(yRot);
        double pitch = Math.toRadians(xRot);
        double x = -Math.sin(yaw) * Math.cos(pitch);
        double y = -Math.sin(pitch);
        double z = Math.cos(yaw) * Math.cos(pitch);
        return new Vec3(x, y, z).m_82541_();
    }

    public static Vec3 getAngleTo(LivingEntity viewer, Entity target) {
        return viewer.m_146892_().m_82505_(target.m_20318_(1.0f)).m_82541_();
    }

    public static Vec3 getEyeAngleTo(LivingEntity viewer, LivingEntity target) {
        return viewer.m_146892_().m_82505_(target.m_146892_()).m_82541_();
    }

    public static Pair<Float, Float> getRotation(Vec3 angle) {
        float yRot = (float)(Mth.m_14136_((double)angle.f_82481_, (double)angle.f_82479_) * 57.2957763671875) - 90.0f;
        float xRot = (float)(-(Mth.m_14136_((double)angle.f_82480_, (double)angle.m_165924_()) * 57.2957763671875));
        return Pair.of((Object)Float.valueOf(yRot), (Object)Float.valueOf(xRot));
    }

    public static Pair<Float, Float> getRotationTo(LivingEntity viewer, LivingEntity target) {
        Vec3 angle = EntityUtils.getEyeAngleTo(viewer, target);
        return EntityUtils.getRotation(angle);
    }

    public static double getDistanceToEntity(LivingEntity viewer, Entity target) {
        return viewer.m_146892_().m_82554_(target.m_20318_(1.0f));
    }

    public static boolean isLookingAt(LivingEntity viewer, Entity target) {
        return EntityUtils.isLookingAt(viewer, target, 0.025);
    }

    public static boolean isLookingAt(LivingEntity viewer, Entity target, double threshold) {
        Vec3 vec3 = viewer.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(target.m_20185_() - viewer.m_20185_(), target.m_20188_() - viewer.m_20188_(), target.m_20189_() - viewer.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - threshold / d0 && viewer.m_142582_(target);
    }

    public static boolean is(@Nullable Entity e1, @Nullable Entity e2) {
        if (e1 == null || e2 == null) {
            return false;
        }
        return e1.m_7306_(e2);
    }

    public static boolean isPlayerOwnedEntity(Entity entity) {
        Projectile projectile;
        TamableAnimal animal;
        if (entity instanceof Player) {
            return true;
        }
        if (entity instanceof TamableAnimal && (animal = (TamableAnimal)entity).m_269323_() instanceof Player) {
            return true;
        }
        return entity instanceof Projectile && (projectile = (Projectile)entity).m_19749_() instanceof Player;
    }

    public static List<ServerPlayer> getTargetablePlayers(ServerLevel level) {
        return level.m_8795_(EntityUtils::isPlayerTargetable);
    }

    public static List<ServerPlayer> getTargetablePlayers(ServerLevel level, Predicate<ServerPlayer> additionalCheck) {
        return level.m_8795_(EntityUtils::isPlayerTargetable).stream().filter(additionalCheck).toList();
    }

    public static List<ServerPlayer> getTargetablePlayers(ServerLevel level, AABB boundingBox) {
        return level.m_6443_(ServerPlayer.class, boundingBox, EntityUtils::isPlayerTargetable);
    }

    public static boolean isPlayerTargetable(Player player) {
        return !player.m_5833_() && !player.m_7500_() && !player.m_21224_();
    }

    public static void sendPlayerToOverworld(ServerPlayer player) {
        ServerLevel overworldLevel = WorldUtils.getOverworldLevel(player).orElseThrow();
        Vec3 overworldLocation = Capabilities.serverPlayer(player).getOverworldLocation();
        EntityUtils.sendEntityToLevel(overworldLevel, (LivingEntity)player, overworldLocation);
    }

    public static void sendPlayerToBossRoom(ServerPlayer player) {
        if (WorldUtils.isOverworldDimension(player.m_9236_())) {
            Capabilities.serverPlayer(player).setOverworldLocation(player.m_20318_(1.0f));
        }
        ServerLevel bossRoomLevel = WorldUtils.getBossRoomLevel(player).orElseThrow();
        Vec3 location = new Vec3(0.0, 32.0, 0.0);
        EntityUtils.sendEntityToLevel(bossRoomLevel, (LivingEntity)player, location);
    }

    public static void sendEntityToLevel(ServerLevel level, LivingEntity entity, Vec3 location) {
        entity.m_264318_(level, location.f_82479_, location.f_82480_, location.f_82481_, new HashSet(), 0.0f, 0.0f);
    }

    public static void teleportToTarget(LivingEntity entityToTeleport, LivingEntity target, int offset, boolean checkIfLookingAt) {
        Vec3 eyePosition = target.m_20299_(1.0f);
        Vec3 lookVector = target.m_20252_(1.0f);
        double offsetX = lookVector.f_82479_ * (double)offset;
        double offsetZ = lookVector.f_82481_ * (double)offset;
        if (checkIfLookingAt && EntityUtils.isLookingAt(target, (Entity)entityToTeleport, 1.0)) {
            offsetX *= -1.0;
            offsetZ *= -1.0;
        }
        entityToTeleport.m_6021_(eyePosition.f_82479_ + offsetX, entityToTeleport.m_20186_(), eyePosition.f_82481_ + offsetZ);
        entityToTeleport.m_9236_().m_245803_((Entity)entityToTeleport, entityToTeleport.m_20097_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    public static List<SlotResult> getCuriosSlots(LivingEntity entity) {
        ArrayList registeredCuriosSlots = Lists.newArrayList((Object[])new String[]{SlotTypePreset.BACK.getIdentifier(), SlotTypePreset.BELT.getIdentifier(), SlotTypePreset.NECKLACE.getIdentifier()});
        return registeredCuriosSlots.stream().map(id -> EntityUtils.getCuriosSlot(entity, id)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public static void removeCurios(LivingEntity entity) {
        ArrayList registeredCuriosSlots = Lists.newArrayList((Object[])new String[]{SlotTypePreset.BACK.getIdentifier(), SlotTypePreset.BELT.getIdentifier(), SlotTypePreset.NECKLACE.getIdentifier()});
        registeredCuriosSlots.forEach(s -> EntityUtils.setCuriosSlot(entity, s, ItemStack.f_41583_));
    }

    public static void setCuriosSlot(LivingEntity entity, String slotId, ItemStack stack) {
        LazyOptional inventory = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (!inventory.isPresent()) {
            return;
        }
        ((ICuriosItemHandler)inventory.orElseThrow(IllegalStateException::new)).setEquippedCurio(slotId, 0, stack);
    }

    public static Optional<SlotResult> getCuriosSlot(LivingEntity entity, String curioSlotId) {
        LazyOptional inventory = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (!inventory.isPresent()) {
            return Optional.empty();
        }
        return ((ICuriosItemHandler)inventory.orElseThrow(IllegalStateException::new)).findCurio(curioSlotId, 0);
    }

    public static Optional<ICurio> getCurio(LivingEntity entity, String curioSlotId) {
        Optional<ItemStack> itemStack = EntityUtils.getCuriosSlot(entity, curioSlotId).map(SlotResult::stack).filter(stack -> !stack.m_41619_());
        if (itemStack.isEmpty()) {
            return Optional.empty();
        }
        LazyOptional curio = CuriosApi.getCurio((ItemStack)itemStack.get());
        return curio.resolve();
    }

    public static boolean isClientSide(Entity entity) {
        return entity.m_9236_().f_46443_;
    }

    public static Optional<ServerLevel> getServerLevel(LivingEntity entity) {
        if (EntityUtils.isClientSide((Entity)entity)) {
            return Optional.empty();
        }
        return Optional.of((ServerLevel)entity.m_9236_());
    }

    public static void playSound(LivingEntity entity, SoundEvent sound) {
        EntityUtils.playSound(entity, sound, 1.0f);
    }

    public static void playSound(LivingEntity entity, SoundEvent sound, float volume) {
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), sound, SoundSource.PLAYERS, volume, 1.0f);
    }

    public static void playSounds(LivingEntity entity, List<SoundEvent> sounds) {
        for (SoundEvent sound : sounds) {
            EntityUtils.playSound(entity, sound);
        }
    }

    public static void swing(ServerPlayer serverPlayer) {
        ClientEntityTransform.Message.Builder message = new ClientEntityTransform.Message.Builder(serverPlayer.m_19879_()).swing();
        NetworkChannel.sendToClient(serverPlayer, message.build());
    }

    public static boolean isFalling(LivingEntity entity) {
        BlockPos onPos = entity.m_20097_();
        Level level = entity.m_9236_();
        return level.m_8055_(onPos).m_60795_();
    }

    public static boolean isPvpEnabledEntity(LivingEntity livingEntity) {
        TamableAnimal animal;
        LivingEntity livingEntity2;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            return Capabilities.serverPlayer(serverPlayer).isPvpEnabled();
        }
        if (livingEntity instanceof TamableAnimal && (livingEntity2 = (animal = (TamableAnimal)livingEntity).m_269323_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
            return Capabilities.serverPlayer(serverPlayer).isPvpEnabled();
        }
        return false;
    }
}

