/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.utils;

import com.dee12452.gahoodrpg.common.combat.GahAttribute;
import com.dee12452.gahoodrpg.common.combat.GahAttributeModifiers;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.items.armor.GahArmors;
import com.dee12452.gahoodrpg.common.items.curios.GahTrinketItem;
import com.dee12452.gahoodrpg.common.items.weapons.GahWeapons;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemUtils {
    private ItemUtils() {
    }

    public static void setStackSlot(ItemStack stack, EquipmentSlot slot) {
        stack.m_41784_().m_128405_("statSlot", slot.ordinal());
    }

    public static Optional<EquipmentSlot> slotFromItem(ItemStack itemStack) {
        if (Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128441_("statSlot")).orElse(false).booleanValue()) {
            return Optional.of(EquipmentSlot.values()[itemStack.m_41783_().m_128451_("statSlot")]);
        }
        Item item = itemStack.m_41720_();
        EquipmentSlot stackSlot = item.getEquipmentSlot(itemStack);
        if (stackSlot != null) {
            return Optional.of(stackSlot);
        }
        if (GahWeapons.isWeapon(item)) {
            return Optional.of(EquipmentSlot.MAINHAND);
        }
        return GahArmors.getEquipmentSlot(item);
    }

    public static GahStats extractItemStats(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof GahTrinketItem) {
            GahTrinketItem trinket = (GahTrinketItem)item;
            return trinket.getStats();
        }
        Optional<EquipmentSlot> slot = ItemUtils.slotFromItem(stack);
        return slot.map(equipmentSlot -> ItemUtils.extractItemStats(stack, equipmentSlot)).orElse(GahStats.EMPTY);
    }

    public static GahStats extractItemStats(ItemStack stack, EquipmentSlot slot) {
        float strength = GahAttributeModifiers.getGahStatAmount(stack, slot, (Attribute)GahAttribute.STRENGTH.get());
        float intelligence = GahAttributeModifiers.getGahStatAmount(stack, slot, (Attribute)GahAttribute.INTELLIGENCE.get());
        float toughness = GahAttributeModifiers.getGahStatAmount(stack, slot, (Attribute)GahAttribute.TOUGHNESS.get());
        float toughnessPercent = GahAttributeModifiers.getGahStatAmount(stack, slot, (Attribute)GahAttribute.TOUGHNESS_PERCENT.get());
        float aegis = GahAttributeModifiers.getGahStatAmount(stack, slot, (Attribute)GahAttribute.AEGIS.get());
        float aegisPercent = GahAttributeModifiers.getGahStatAmount(stack, slot, (Attribute)GahAttribute.AEGIS_PERCENT.get());
        float dexterity = GahAttributeModifiers.getGahStatAmount(stack, slot, (Attribute)GahAttribute.DEXTERITY.get());
        float health = GahAttributeModifiers.getGahStatAmount(stack, slot, (Attribute)GahAttribute.VITALITY.get());
        float alacrity = GahAttributeModifiers.getGahStatAmount(stack, slot, (Attribute)GahAttribute.ALACRITY.get());
        return new GahStats.Builder().strength(strength).intelligence(intelligence).toughness(toughness).toughnessPercent(toughnessPercent).aegis(aegis).aegisPercent(aegisPercent).dexterity(dexterity).vitality(health).alacrity(alacrity).build();
    }

    public static ItemStack createCopyWithSetStats(ItemStack result, EquipmentSlot slot, GahStats stats) {
        ItemStack copyStack = new ItemStack((ItemLike)result.m_41720_());
        GahAttributeModifiers.setStatModifiers(copyStack, slot, stats);
        return copyStack;
    }

    public static ItemStack createCopyWithAddedStats(ItemStack result, EquipmentSlot slot, GahStats stats, List<Attribute> ignoredAttributes) {
        ItemStack copyStack = new ItemStack((ItemLike)result.m_41720_());
        GahAttributeModifiers.addStatModifiers(copyStack, slot, stats, ignoredAttributes);
        return copyStack;
    }

    public static Item fromId(int id) {
        return id < 0 ? Items.f_41852_ : Item.m_41445_((int)id);
    }

    public static String toSlotName(EquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return "helmet";
            }
            case CHEST: {
                return "chestplate";
            }
            case LEGS: {
                return "leggings";
            }
            case FEET: {
                return "boots";
            }
        }
        return slot.m_20751_();
    }
}

