/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class NbtUtils {
    private NbtUtils() {
    }

    public static <T> void putIfPresent(CompoundTag nbt, String name, @Nullable T item, NbtWriter<T> writer) {
        if (item == null) {
            return;
        }
        writer.write(nbt, name, item);
    }

    public static <T> Optional<T> getIfPresent(CompoundTag nbt, String name, NbtReader<T> reader) {
        if (nbt.m_128441_(name)) {
            return Optional.of(reader.read(nbt, name));
        }
        return Optional.empty();
    }

    public static <K, T> void writeMap(CompoundTag nbt, String name, Map<K, T> items, Function<K, String> keyTranslator, NbtWriter<T> writer) {
        CompoundTag map = new CompoundTag();
        for (Map.Entry<K, T> entry : items.entrySet()) {
            writer.write(map, keyTranslator.apply(entry.getKey()), entry.getValue());
        }
        nbt.m_128365_(name, (Tag)map);
    }

    public static <K, T> Map<K, T> readMap(CompoundTag nbt, String name, Function<String, K> keyTranslator, NbtReader<T> reader) {
        HashMap<K, T> result = new HashMap<K, T>();
        CompoundTag map = nbt.m_128469_(name);
        for (String key : map.m_128431_()) {
            result.put(keyTranslator.apply(key), reader.read(map, key));
        }
        return result;
    }

    public static <T> void writeList(CompoundTag nbt, String name, List<T> items, NbtWriter<T> writer) {
        nbt.m_128405_(String.format("%sSize", name), items.size());
        for (int idx = 0; idx < items.size(); ++idx) {
            writer.write(nbt, String.format("%s%d", name, idx), items.get(idx));
        }
    }

    public static <T> List<T> readList(CompoundTag nbt, String name, NbtReader<T> reader) {
        int size = nbt.m_128451_(String.format("%sSize", name));
        ArrayList<T> arr = new ArrayList<T>();
        for (int idx = 0; idx < size; ++idx) {
            arr.add(reader.read(nbt, String.format("%s%d", name, idx)));
        }
        return arr;
    }

    public static void writeBlockPos(CompoundTag nbt, String prefix, BlockPos pos) {
        nbt.m_128405_(String.format("%sX", prefix), pos.m_123341_());
        nbt.m_128405_(String.format("%sY", prefix), pos.m_123342_());
        nbt.m_128405_(String.format("%sZ", prefix), pos.m_123343_());
    }

    public static BlockPos readBlockPos(CompoundTag nbt, String prefix) {
        return new BlockPos(nbt.m_128451_(String.format("%sX", prefix)), nbt.m_128451_(String.format("%sY", prefix)), nbt.m_128451_(String.format("%sZ", prefix)));
    }

    public static boolean hasBlockPos(CompoundTag nbt, String prefix) {
        return nbt.m_128441_(String.format("%sX", prefix)) && nbt.m_128441_(String.format("%sY", prefix)) && nbt.m_128441_(String.format("%sZ", prefix));
    }

    public static <T extends INBTSerializable<CompoundTag>> void putMap(CompoundTag nbt, String id, Map<UUID, T> map) {
        CompoundTag mapNbt = new CompoundTag();
        map.forEach((uuid, obj) -> mapNbt.m_128365_(uuid.toString(), obj.serializeNBT()));
        nbt.m_128365_(id, (Tag)mapNbt);
    }

    public static <T extends INBTSerializable<CompoundTag>> void extractMap(CompoundTag nbt, String id, Map<UUID, T> map, Function<UUID, T> defaultObj) {
        CompoundTag mapNbt = nbt.m_128469_(id);
        for (String uuidStr : mapNbt.m_128431_()) {
            UUID uuid = UUID.fromString(uuidStr);
            if (!map.containsKey(uuid)) {
                map.put(uuid, (INBTSerializable)defaultObj.apply(uuid));
            }
            ((INBTSerializable)map.get(uuid)).deserializeNBT((Tag)mapNbt.m_128469_(uuidStr));
        }
    }

    public static interface NbtWriter<T> {
        public void write(CompoundTag var1, String var2, T var3);
    }

    public static interface NbtReader<T> {
        public T read(CompoundTag var1, String var2);
    }

    public static interface CompountNbtReader<T extends INBTSerializable<CompoundTag>>
    extends NbtReader<T> {
        @Override
        default public T read(CompoundTag nbt, String name) {
            T obj = this.createDefault();
            obj.deserializeNBT((Tag)nbt.m_128469_(name));
            return obj;
        }

        public T createDefault();
    }
}

