/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.utils;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;

public class RoleUtils {
    private RoleUtils() {
    }

    public static void modifyRole(Player player, Consumer<IGahRole> roleConsumer) {
        CommonPlayerCapability cap = Capabilities.commonPlayer(player);
        cap.getCurrentRole().ifPresent(roleConsumer);
    }

    public static IGahSpell getSpellById(Player player, UUID id) {
        CommonPlayerCapability cap = Capabilities.commonPlayer(player);
        return cap.getSpell(id);
    }

    public static Optional<IGahRole> getCurrentRole(Player player) {
        CommonPlayerCapability cap = Capabilities.commonPlayer(player);
        return cap.getCurrentRole();
    }

    public static List<IGahSpell> getCurrentSpells(Player player) {
        CommonPlayerCapability cap = Capabilities.commonPlayer(player);
        return cap.getCurrentRole().map(role -> role.getAllSpells(player)).orElse(new ArrayList());
    }

    public static List<IGahSpell> getUsableSpells(Player player) {
        return RoleUtils.getCurrentSpells(player).stream().filter(IGahSpell::canUse).toList();
    }
}

