/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.utils;

import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WorldUtils {
    public static final ResourceLocation BOSS_ROOM_DIMENSION = new ResourceLocationBuilder("boss_room").named();
    public static final ResourceLocation BOSS_ROOM_BIOME = new ResourceLocationBuilder("boss_room_biome").named();
    public static final ResourceLocation VANILLA_OVERWORLD_DIMENSION = new ResourceLocation("minecraft", "overworld");

    private WorldUtils() {
    }

    public static Optional<RegistryAccess> getRegistryAccess(@Nullable Level level) {
        if (level == null) {
            return Optional.empty();
        }
        if (level.f_46443_) {
            return Optional.of(Minecraft.m_91087_()).map(Minecraft::m_91403_).map(ClientPacketListener::m_105152_);
        }
        return Optional.of(level).map(Level::m_7654_).map(MinecraftServer::m_206579_);
    }

    public static Optional<Either<LivingEntity, BlockPos>> findFirstHit(LivingEntity viewer, double maxDistance) {
        Optional<LivingEntity> entity = EntityUtils.raytraceLivingEntity(viewer, maxDistance);
        if (entity.isPresent()) {
            return Optional.of(Either.left((Object)entity.get()));
        }
        Optional<BlockPos> hitBlockPos = WorldUtils.raytraceBlock((Entity)viewer, maxDistance);
        return hitBlockPos.map(Either::right);
    }

    public static Optional<BlockPos> raytraceBlock(Entity viewer, double maxDistance) {
        HitResult hitResult = viewer.m_19907_(maxDistance, 1.0f, false);
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            return Optional.of(blockHitResult.m_82425_());
        }
        return Optional.empty();
    }

    public static BlockPos raytraceBlockNoY(Entity viewer, double maxDistance) {
        Vec3 eyePos = viewer.m_146892_();
        BlockPos blockPos = WorldUtils.raytraceBlockAtPos(eyePos, viewer, maxDistance);
        if (WorldUtils.isNotAir(viewer.m_9236_(), blockPos)) {
            return blockPos;
        }
        Vec3 pos = viewer.m_20318_(1.0f);
        return WorldUtils.raytraceBlockAtPos(pos, viewer, maxDistance);
    }

    private static BlockPos raytraceBlockAtPos(Vec3 pos, Entity viewer, double distance) {
        Vec3 lookVec = viewer.m_20154_();
        Vec3 target = pos.m_82520_(lookVec.f_82479_ * distance, 0.0, lookVec.f_82481_ * distance);
        return viewer.m_9236_().m_45547_(new ClipContext(pos, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, viewer)).m_82425_();
    }

    public static Vec3 getBlockPosCenter(BlockPos pos) {
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static boolean isNotAir(Level level, Vec3 pos) {
        Vec3i vec3i = new Vec3i((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
        return !level.m_8055_(new BlockPos(vec3i)).m_60795_();
    }

    public static boolean isNotAir(Level level, BlockPos pos) {
        return !level.m_8055_(new BlockPos((Vec3i)pos)).m_60795_();
    }

    public static void playSound(Level level, SoundEvent sound, BlockPos location, float volume) {
        WorldUtils.playSound(level, sound, new Vec3((double)location.m_123341_(), (double)location.m_123342_(), (double)location.m_123343_()), volume);
    }

    public static void playSound(Level level, SoundEvent sound, Vec3 location, float volume) {
        level.m_6263_(null, location.f_82479_, location.f_82480_, location.f_82481_, sound, SoundSource.PLAYERS, volume, 1.0f);
    }

    public static boolean isOverworldDimension(Level level) {
        return level.m_46472_().m_135782_().equals((Object)VANILLA_OVERWORLD_DIMENSION);
    }

    public static boolean isBossRoomDimension(Level level) {
        return level.m_46472_().m_135782_().equals((Object)BOSS_ROOM_DIMENSION);
    }

    public static boolean isBossRoomDimension(LevelAccessor level) {
        return level.m_204166_(new BlockPos(0, 32, 0)).m_203373_(BOSS_ROOM_BIOME);
    }

    public static Optional<ServerLevel> getBossRoomLevel(ServerPlayer player) {
        if (player.m_20194_() == null) {
            return Optional.empty();
        }
        return WorldUtils.getLevel(player.m_20194_(), WorldUtils::isBossRoomDimension);
    }

    public static Optional<ServerLevel> getOverworldLevel(ServerPlayer player) {
        if (player.m_20194_() == null) {
            return Optional.empty();
        }
        return WorldUtils.getLevel(player.m_20194_(), WorldUtils::isOverworldDimension);
    }

    public static Optional<ServerLevel> getOverworldLevel(MinecraftServer server) {
        return WorldUtils.getLevel(server, WorldUtils::isOverworldDimension);
    }

    public static BlockPos toBlockPos(Vec3 vec3) {
        return BlockPos.m_274561_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_);
    }

    public static Vec3 toVec3(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static boolean isBiome(Level level, BlockPos pos, String tag) {
        Holder currentBiome = level.m_204166_(pos);
        Registry biomeRegistry = (Registry)level.m_9598_().m_6632_(Registries.f_256952_).orElseThrow();
        Optional<TagKey> biomeTag = biomeRegistry.m_203613_().filter(t -> t.f_203868_().toString().contains(tag)).findFirst();
        return biomeTag.map(arg_0 -> ((Holder)currentBiome).containsTag(arg_0)).orElse(false);
    }

    private static Optional<ServerLevel> getLevel(MinecraftServer server, Predicate<ServerLevel> levelFilter) {
        Iterable levels = server.m_129785_();
        for (ServerLevel level : levels) {
            if (!levelFilter.test(level)) continue;
            return Optional.of(level);
        }
        return Optional.empty();
    }
}

