/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.gimmick.api.gimmick;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.gimmick.api.gimmick.Gimmicks;
import com.provismet.cobblemon.gimmick.config.Options;
import com.provismet.cobblemon.gimmick.registry.GTGEnchantmentComponents;
import com.provismet.cobblemon.gimmick.registry.GTGItemDataComponents;
import com.provismet.cobblemon.gimmick.util.tag.GTGBlockTags;
import com.provismet.cobblemon.gimmick.util.tag.GTGItemTags;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public interface GimmickCheck {
    public static boolean isKeyStone(class_1799 item) {
        return GimmickCheck.isUnenchantedKeyStone(item) || class_1890.method_60142((class_1799)item, GTGEnchantmentComponents.KEY_STONE);
    }

    public static boolean isZRing(class_1799 item) {
        return item.method_31573(GTGItemTags.Z_RINGS) || item.method_57824(GTGItemDataComponents.Z_RING) != null || class_1890.method_60142((class_1799)item, GTGEnchantmentComponents.Z_RING);
    }

    public static boolean isDynamaxBand(class_1799 item) {
        return item.method_31573(GTGItemTags.DYNAMAX_BANDS) || item.method_57824(GTGItemDataComponents.DYNAMAX_BAND) != null || class_1890.method_60142((class_1799)item, GTGEnchantmentComponents.DYNAMAX_BAND);
    }

    public static boolean isTeraOrb(class_1799 item) {
        if (item.method_31573(GTGItemTags.BREAKABLE_TERA_ORBS) && item.method_7963() && item.method_7919() == item.method_7936()) {
            return false;
        }
        return item.method_31573(GTGItemTags.TERA_ORBS) || item.method_57824(GTGItemDataComponents.TERA_ORB) != null || class_1890.method_60142((class_1799)item, GTGEnchantmentComponents.TERA_ORB);
    }

    public static boolean isUnenchantedKeyStone(class_1799 item) {
        return item.method_31573(GTGItemTags.KEY_STONES) || item.method_57824(GTGItemDataComponents.KEY_STONE) != null;
    }

    public static void applyGimmicks(class_3222 player) {
        GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
        boolean hasKeyStone = false;
        boolean hasZRing = false;
        boolean hasDynamax = false;
        boolean hasTeraOrb = false;
        class_1799 teraOrb = null;
        for (class_1799 item : player.method_56675()) {
            if (Options.enabledMegaEvolution() && GimmickCheck.isKeyStone(item)) {
                hasKeyStone = true;
            }
            if (Options.enabledZMoves() && GimmickCheck.isZRing(item)) {
                hasZRing = true;
            }
            if (Options.enabledDynamax() && GimmickCheck.isDynamaxBand(item)) {
                hasDynamax = true;
            }
            if (!Options.enabledTerastal() || !GimmickCheck.isTeraOrb(item)) continue;
            hasTeraOrb = true;
            teraOrb = item;
        }
        if (hasTeraOrb) {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (Pokemon partyMons : playerPartyStore) {
                if (!partyMons.getSpecies().getName().equals("Terapagos")) continue;
                teraOrb.method_7974(0);
                break;
            }
        }
        if (hasKeyStone) {
            data.getKeyItems().add(Gimmicks.KEY_STONE);
        } else {
            data.getKeyItems().remove(Gimmicks.KEY_STONE);
        }
        if (hasZRing) {
            data.getKeyItems().add(Gimmicks.Z_RING);
        } else {
            data.getKeyItems().remove(Gimmicks.Z_RING);
        }
        boolean bl = hasDynamax = hasDynamax && (!Options.isPowerSpotRequired() || GimmickCheck.powerSpotInRange((class_1937)player.method_51469(), player.method_24515(), Options.getPowerSpotRange()));
        if (hasDynamax && !hasTeraOrb) {
            data.getKeyItems().add(Gimmicks.DYNAMAX_BAND);
        } else {
            data.getKeyItems().remove(Gimmicks.DYNAMAX_BAND);
        }
        if (hasTeraOrb) {
            data.getKeyItems().add(Gimmicks.TERA_ORB);
        } else {
            data.getKeyItems().remove(Gimmicks.TERA_ORB);
        }
    }

    public static boolean powerSpotInRange(class_1937 world, class_2338 pos, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 checkPos = pos.method_10069(dx, dy, dz);
                    if (!world.method_8320(checkPos).method_26164(GTGBlockTags.POWER_SPOTS)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

