package com.provismet.cobblemon.gimmick.api.data;

import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.IntSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

/**
 * @param featureMap A mapping of feature name to value. All are applied to the Pokémon when triggered.
 */
public record PokemonFeatures (Map<String, FeatureValue> featureMap) {
    public static final Codec<PokemonFeatures> CODEC = Codec.unboundedMap(Codec.STRING, FeatureValue.CODEC).xmap(PokemonFeatures::new, PokemonFeatures::featureMap);

    public static final class_9139<class_9129, PokemonFeatures> PACKET_CODEC = class_9139.method_56434(
        class_9135.method_56377(Object2ObjectOpenHashMap::new, class_9135.field_48554, FeatureValue.PACKET_CODEC),
        PokemonFeatures::featureMap,
        PokemonFeatures::new
    );

    public static PokemonFeatures single (String name, String value) {
        return new PokemonFeatures(Map.of(name, FeatureValue.of(value)));
    }

    public static PokemonFeatures single (String name, boolean value) {
        return new PokemonFeatures(Map.of(name, FeatureValue.of(value)));
    }

    public static PokemonFeatures single (String name, int value) {
        return new PokemonFeatures(Map.of(name, FeatureValue.of(value)));
    }

    public void apply (Pokemon pokemon) {
        for (Map.Entry<String, FeatureValue> feature : this.featureMap.entrySet()) {
            feature.getValue().value()
                .ifLeft(string -> new StringSpeciesFeature(feature.getKey(), string).apply(pokemon))
                .ifRight(boolOrInt -> {
                    boolOrInt.ifLeft(bool -> new FlagSpeciesFeature(feature.getKey(), bool).apply(pokemon));
                    boolOrInt.ifRight(integer -> new IntSpeciesFeature(feature.getKey(), integer).apply(pokemon));
                });
        }
    }

    /**
     * A wrapper around strings, booleans, and integers. Allowing any of those primitives to be used in the json.
     * <p>
     * It is recommended to use the static constructors instead of fiddling with the canonical constructor.
     *
     * @param value An Either<> object for the value.
     */
    public record FeatureValue (Either<String, Either<Boolean, Integer>> value) {
        public static final Codec<FeatureValue> CODEC = Codec.either(
            class_5699.field_41759,
            Codec.either(Codec.BOOL, Codec.INT)
        ).xmap(FeatureValue::of, FeatureValue::value);

        public static final class_9139<class_9129, FeatureValue> PACKET_CODEC = class_9139.method_56434(
            class_9135.method_57995(class_9135.field_48554, class_9135.method_57995(class_9135.field_48547, class_9135.field_49675)),
            FeatureValue::value,
            FeatureValue::new
        );

        public static FeatureValue of (String value) {
            return new FeatureValue(Either.left(value));
        }

        public static FeatureValue of (boolean value) {
            return new FeatureValue(Either.right(Either.left(value)));
        }

        public static FeatureValue of (int value) {
            return new FeatureValue(Either.right(Either.right(value)));
        }

        public static FeatureValue of (Either<String, Either<Boolean, Integer>> value) {
            if (value.left().isPresent()) return FeatureValue.of(value.left().get());
            if (value.right().isPresent()) {
                if (value.right().get().left().isPresent()) return FeatureValue.of(value.right().get().left().get());
                if (value.right().get().right().isPresent()) return FeatureValue.of(value.right().get().right().get());
            }

            // This point should never be reached, and if you do then you'll get an error.
            return null;
        }
    }
}
