package com.provismet.cobblemon.gimmick.api.data.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.cobblemon.gimmick.api.data.DataItemStack;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9280;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

/**
 * Represents the base data for generic items created through data-driven features.
 * <p>
 * Used as a component for the data-driven items.
 *
 * @param name The custom item name.
 * @param tooltip A list of tooltip lines.
 * @param baseItem The id for the vanilla item to use as the base.
 * @param customModelData The custom model data.
 * @param rarity The item's rarity.
 */
public record DataItem (String name, List<String> tooltip, class_2960 baseItem, Optional<Integer> customModelData, class_1814 rarity) implements DataItemStack {
    public static final Codec<DataItem> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        Codec.STRING.fieldOf("name").forGetter(DataItem::name),
        Codec.STRING.listOf().optionalFieldOf("tooltip", List.of()).forGetter(DataItem::tooltip),
        class_2960.field_25139.fieldOf("vanillaItem").forGetter(DataItem::baseItem),
        class_5699.field_33441.optionalFieldOf("customModelData").forGetter(DataItem::customModelData),
        class_1814.field_50001.optionalFieldOf("rarity", class_1814.field_8906).forGetter(DataItem::rarity)
    ).apply(instance, DataItem::new));

    public static final class_9139<class_9129, DataItem> PACKET_CODEC = class_9139.method_56906(
        class_9135.field_48554,
        DataItem::name,
        class_9135.field_48554.method_56433(class_9135.method_56363()),
        DataItem::tooltip,
        class_2960.field_48267,
        DataItem::baseItem,
        class_9135.method_56382(class_9135.field_49675),
        DataItem::customModelData,
        class_1814.field_50003,
        DataItem::rarity,
        DataItem::new
    );

    @Override
    @Nullable
    public class_1799 create () {
        Optional<class_1792> item = class_7923.field_41178.method_17966(this.baseItem);
        if (item.isPresent()) {
            class_1799 stack = new class_1799(item.get());
            this.applyTo(stack);
            return stack;
        }
        return null;
    }

    public void applyTo (class_1799 stack) {
        stack.method_57379(class_9334.field_49631, class_2561.method_43470(this.name).method_27694(style -> style.method_10978(false)));

        if (!this.tooltip.isEmpty()) {
            stack.method_57379(class_9334.field_49632, new class_9290(
                this.tooltip
                    .stream()
                    .map(line -> (class_2561)class_2561.method_43470(line).method_27694(style -> style.method_10978(false).method_27706(class_124.field_1080)))
                    .toList()
            ));
        }
        stack.method_57379(class_9334.field_50073, this.rarity);
        this.customModelData.ifPresent(integer -> stack.method_57379(class_9334.field_49637, new class_9280(integer)));
    }
}
