package com.provismet.cobblemon.gimmick.api.data.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.cobblemon.gimmick.api.data.PokemonFeatures;
import com.provismet.cobblemon.gimmick.api.data.PokemonRequirements;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

/**
 * A data component used exclusively by the {@link com.provismet.cobblemon.gimmick.item.forms.DataDrivenToggleItem} item.
 * <p>
 * Toggles the pokemon between two forms. The fields are labelled under the assumption that the Pokémon as a default state
 * and a special state, but this is not necessary in practice.
 *
 * @param validPokemon Checks if a given Pokémon is valid to have its form toggled.
 * @param shouldApply Checks if the Pokémon is in its default state. If true the onApply features are used, otherwise the onRemove features are used.
 * @param onApply Features applied to put the Pokémon in its special state.
 * @param onRemove Features applied to put the Pokémon in its default state.
 * @param effects Optional identifier of an EffectsData object.
 */
public record FormToggle (PokemonRequirements validPokemon, PokemonRequirements shouldApply, PokemonFeatures onApply, PokemonFeatures onRemove, Optional<class_2960> effects) {
    public static final Codec<FormToggle> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        PokemonRequirements.CODEC.fieldOf("validPokemon").forGetter(FormToggle::validPokemon),
        PokemonRequirements.CODEC.fieldOf("applyIf").forGetter(FormToggle::shouldApply),
        PokemonFeatures.CODEC.fieldOf("featuresOnApply").forGetter(FormToggle::onApply),
        PokemonFeatures.CODEC.fieldOf("featuresOnRemove").forGetter(FormToggle::onRemove),
        class_2960.field_25139.optionalFieldOf("effects").forGetter(FormToggle::effects)
    ).apply(instance, FormToggle::new));

    public static final class_9139<class_9129, FormToggle> PACKET_CODEC = class_9139.method_56906(
        PokemonRequirements.PACKET_CODEC,
        FormToggle::validPokemon,
        PokemonRequirements.PACKET_CODEC,
        FormToggle::shouldApply,
        PokemonFeatures.PACKET_CODEC,
        FormToggle::onApply,
        PokemonFeatures.PACKET_CODEC,
        FormToggle::onRemove,
        class_9135.method_56382(class_2960.field_48267),
        FormToggle::effects,
        FormToggle::new
    );
}
