package com.provismet.cobblemon.gimmick.api.data.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.cobblemon.gimmick.api.data.PokemonFeatures;
import com.provismet.cobblemon.gimmick.api.data.PokemonRequirements;
import java.util.List;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

/**
 * Used as a data component by all mega stones, both coded and data-driven ones.
 *
 * @param pokemon The Pokémon must fulfil these requirement to use this mega stone.
 * @param onApply The features applied when the Pokémon mega evolves.
 * @param onRemove The features applied when the Pokémon mega devolves.
 */
public record MegaEvolution (PokemonRequirements pokemon, PokemonFeatures onApply, PokemonFeatures onRemove) {
    public static final MegaEvolution DEFAULT = MegaEvolution.create("none");
    public static final MegaEvolution RAYQUAZA = new MegaEvolution(
        new PokemonRequirements(
            List.of("rayquaza"),
            List.of(),
            List.of(),
            List.of(),
            List.of("dragonascent"),
            List.of()
        ),
        PokemonFeatures.single("mega_evolution", "mega"),
        PokemonFeatures.single("mega_evolution", "none")
    );

    public static final Codec<MegaEvolution> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        PokemonRequirements.CODEC.fieldOf("pokemon").forGetter(MegaEvolution::pokemon),
        PokemonFeatures.CODEC.optionalFieldOf("appliedFeatures", PokemonFeatures.single("mega_evolution", "mega")).forGetter(MegaEvolution::onApply),
        PokemonFeatures.CODEC.optionalFieldOf("defaultFeatures", PokemonFeatures.single("mega_evolution", "none")).forGetter(MegaEvolution::onRemove)
    ).apply(instance, MegaEvolution::new));

    public static final class_9139<class_9129, MegaEvolution> PACKET_CODEC = class_9139.method_56436(
        PokemonRequirements.PACKET_CODEC,
        MegaEvolution::pokemon,
        PokemonFeatures.PACKET_CODEC,
        MegaEvolution::onApply,
        PokemonFeatures.PACKET_CODEC,
        MegaEvolution::onRemove,
        MegaEvolution::new
    );

    public static MegaEvolution create (String speciesId) {
        return create(speciesId, "normal");
    }

    public static MegaEvolution create (String speciesId, String formId) {
        return create(speciesId, formId, "mega");
    }

    public static MegaEvolution create (String speciesId, String formId, String megaAspect) {
        return new MegaEvolution(
            PokemonRequirements.speciesForm(speciesId, formId),
            PokemonFeatures.single("mega_evolution", megaAspect),
            PokemonFeatures.single("mega_evolution", "none")
        );
    }
}
