package com.provismet.cobblemon.gimmick.api.data.particle;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.effect.SpawnSnowstormEntityParticlePacket;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;

/**
 * Represents a Snowstorm particle effects, as provided by Cobblemon.
 * <p>
 * Snowstorm particles are custom data-driven particles that can have complex animations.
 *
 * @param id The asset id of the particle.
 * @param sourceLocators List of source locators as required by Snowstorm.
 * @param targetLocators Optional list of target locators as required by Snowstorm.
 *
 * @see SpawnSnowstormEntityParticlePacket
 */
public record SnowstormEffect (class_2960 id, List<String> sourceLocators, Optional<List<String>> targetLocators) implements ParticleAnimation {
    public static final MapCodec<SnowstormEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
        class_2960.field_25139.fieldOf("particleId").forGetter(SnowstormEffect::id),
        Codec.STRING.listOf().optionalFieldOf("sourceLocators", List.of("root")).forGetter(SnowstormEffect::sourceLocators),
        Codec.STRING.listOf().optionalFieldOf("targetLocators").forGetter(SnowstormEffect::targetLocators)
    ).apply(instance, SnowstormEffect::new));

    @Override
    public void runParticles (PokemonEntity source, @Nullable PokemonEntity target) {
        SpawnSnowstormEntityParticlePacket packet = new SpawnSnowstormEntityParticlePacket(
            this.id,
            source.method_5628(),
            this.sourceLocators,
            target == null ? null : target.method_5628(),
            target == null || this.targetLocators.isEmpty() ? null : this.targetLocators.get()
        );
        CobblemonNetwork.INSTANCE.sendToAllPlayers(packet);
    }
}
