package com.provismet.cobblemon.gimmick.api.data.particle;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import net.minecraft.class_7923;

/**
 * Creates a spray of particles from vanilla types.
 *
 * @param layers List of particle layers to apply.
 */
public record VanillaParticleEffect (List<VanillaParticleLayer> layers) implements ParticleAnimation {
    public static final MapCodec<VanillaParticleEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
        VanillaParticleLayer.CODEC.listOf().fieldOf("layers").forGetter(VanillaParticleEffect::layers)
    ).apply(instance, VanillaParticleEffect::new));


    @Override
    public void runParticles (PokemonEntity source, @Nullable PokemonEntity target) {
        this.layers.forEach(layer -> layer.run(source));
    }

    /**
     * A set of particles to spawn around a PokemonEntity.
     * <p>
     * This only works with simple particles that do not require additional fields.
     *
     * @param id The identifier of the particle type.
     * @param count The number of particles to spawn.
     * @param maxDistance How far each particle can be spawned from the Pokémon.
     */
    public record VanillaParticleLayer (class_2960 id, int count, double maxDistance) {
        public static final Codec<VanillaParticleLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("id").forGetter(VanillaParticleLayer::id),
            class_5699.field_33442.fieldOf("count").forGetter(VanillaParticleLayer::count),
            Codec.DOUBLE.fieldOf("maxDistance").forGetter(VanillaParticleLayer::maxDistance)
        ).apply(instance, VanillaParticleLayer::new));

        public VanillaParticleLayer (class_2396<?> particleType, int count, double maxDistance) {
            this(class_7923.field_41180.method_10221(particleType), count, maxDistance);
        }

        public void run (PokemonEntity source) {
            Optional<class_2396<?>> particle = class_7923.field_41180.method_17966(this.id);
            if (particle.isPresent() && source.method_37908() instanceof class_3218 world && particle.get() instanceof class_2400 particleType) {
                world.method_14199(
                    particleType,
                    source.method_23317(), source.method_23318(), source.method_23321(),
                    this.count,
                    this.maxDistance, this.maxDistance, this.maxDistance,
                    0
                );
            }
        }
    }
}
