package com.provismet.cobblemon.gimmick.api.data.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.cobblemon.gimmick.api.data.component.DataItem;
import com.provismet.cobblemon.gimmick.api.data.DataItemStack;
import com.provismet.cobblemon.gimmick.registry.GTGDynamicRegistryKeys;
import com.provismet.cobblemon.gimmick.registry.GTGItemDataComponents;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

/**
 * A data-driven implementation of Showdown-compatible items.
 *
 * @param itemData The item to create, both client-side and server-side.
 * @param showdownId The Showdown id to associate with this item.
 *
 * @apiNote Bones, snowballs, and leeks should not be used as base items. These items already have Showdown ids and will not work as expected.
 */
public record HeldItem (DataItem itemData, String showdownId) implements DataItemStack {
    public static final Codec<HeldItem> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        DataItem.CODEC.fieldOf("item").forGetter(HeldItem::itemData),
        class_5699.field_41759.fieldOf("showdownId").forGetter(HeldItem::showdownId)
    ).apply(instance, HeldItem::new));

    public static class_5321<HeldItem> key (class_2960 id) {
        return class_5321.method_29179(GTGDynamicRegistryKeys.HELD_ITEM, id);
    }

    @Override
    public String name () {
        return this.itemData.name();
    }

    @Override
    @Nullable
    public class_1799 create () {
        class_1799 stack = this.itemData.create();
        if (stack != null) {
            stack.method_57379(GTGItemDataComponents.SHOWDOWN_ID, this.showdownId);
            stack.method_57381(class_9334.field_50075);
        }

        return stack;
    }
}