package com.provismet.cobblemon.gimmick.api.data.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.cobblemon.gimmick.api.data.component.DataItem;
import com.provismet.cobblemon.gimmick.api.data.DataItemStack;
import com.provismet.cobblemon.gimmick.api.data.component.MegaEvolution;
import com.provismet.cobblemon.gimmick.registry.GTGDynamicRegistryKeys;
import com.provismet.cobblemon.gimmick.registry.GTGItemDataComponents;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

/**
 * Data-driven implementation of mega stones.
 *
 * @param itemData The item to create, both client-side and server-side.
 * @param megaEvolution The mega data to attach to the item.
 * @param showdownId The Showdown id of the item.
 */
public record MegaStone (DataItem itemData, MegaEvolution megaEvolution, String showdownId) implements DataItemStack {
    public static final Codec<MegaStone> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        DataItem.CODEC.fieldOf("item").forGetter(MegaStone::itemData),
        MegaEvolution.CODEC.fieldOf("megaEvolution").forGetter(MegaStone::megaEvolution),
        class_5699.field_41759.fieldOf("showdownId").forGetter(MegaStone::showdownId)
    ).apply(instance, MegaStone::new));

    public static class_5321<MegaStone> key (class_2960 id) {
        return class_5321.method_29179(GTGDynamicRegistryKeys.MEGASTONE, id);
    }

    @Override
    public String name () {
        return this.itemData.name();
    }

    @Override
    @Nullable
    public class_1799 create () {
        class_1799 stack = this.itemData.create();
        if (stack != null) {
            stack.method_57379(GTGItemDataComponents.MEGA_EVOLUTION, this.megaEvolution);
            stack.method_57379(GTGItemDataComponents.SHOWDOWN_ID, this.showdownId);
        }

        return stack;
    }
}