package com.provismet.cobblemon.gimmick.api.data.registry.form;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.cobblemon.gimmick.api.data.component.DataItem;
import com.provismet.cobblemon.gimmick.api.data.DataItemStack;
import com.provismet.cobblemon.gimmick.api.data.component.Fusion;
import com.provismet.cobblemon.gimmick.registry.GTGDynamicRegistryKeys;
import com.provismet.cobblemon.gimmick.registry.GTGItemDataComponents;
import com.provismet.cobblemon.gimmick.registry.GTGItems;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_9334;

/**
 * A data-driven item for triggering Pokémon fusions.
 *
 * @param itemData The client-side representation of the item.
 * @param fusion The fusion to trigger with the item.
 */
public record FormChangeFusionDataItem (DataItem itemData, Fusion fusion) implements DataItemStack {
    public static final Codec<FormChangeFusionDataItem> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        DataItem.CODEC.fieldOf("item").forGetter(FormChangeFusionDataItem::itemData),
        Fusion.CODEC.fieldOf("fusion").forGetter(FormChangeFusionDataItem::fusion)
    ).apply(instance, FormChangeFusionDataItem::new));

    public static class_5321<FormChangeFusionDataItem> key (class_2960 id) {
        return class_5321.method_29179(GTGDynamicRegistryKeys.FUSION, id);
    }

    @Override
    public String name () {
        return this.itemData.name();
    }

    @Override
    public class_1799 create () {
        class_1799 stack = GTGItems.DATA_DRIVEN_FUSION.method_7854();
        stack.method_57379(GTGItemDataComponents.FUSION, this.fusion);
        stack.method_57379(GTGItemDataComponents.DATA_ITEM, this.itemData);
        stack.method_57379(class_9334.field_49631, class_2561.method_30163(this.itemData.name()));
        return stack;
    }
}
