package com.provismet.cobblemon.gimmick.api.datagen;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public abstract class AbstractGTGProvider<T> extends FabricDynamicRegistryProvider {
    private final class_5321<class_2378<T>> registryKey;

    public AbstractGTGProvider (FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture, class_5321<class_2378<T>> key) {
        super(output, registriesFuture);
        this.registryKey = key;
    }

    @Override
    protected void configure (class_7225.class_7874 wrapperLookup, Entries entries) {
        BiConsumer<class_2960, T> consumer = (id, item) -> entries.add(class_5321.method_29179(this.registryKey, id), item);
        this.generate(wrapperLookup, consumer);
    }

    protected abstract void generate (class_7225.class_7874 wrapperLookup, BiConsumer<class_2960, T> consumer);
}
