package com.provismet.cobblemon.gimmick.api.gimmick;

import com.provismet.cobblemon.gimmick.registry.GTGEnchantmentComponents;
import com.provismet.cobblemon.gimmick.registry.GTGItemDataComponents;
import com.provismet.cobblemon.gimmick.util.tag.GTGItemTags;
import net.minecraft.class_1799;
import net.minecraft.class_1890;

/**
 * Utility interface for checking if an item should be considered a gimmick item.
 */
public interface GimmickCheck {
    static boolean isKeyStone (class_1799 item) {
        return isUnenchantedKeyStone(item)
            || class_1890.method_60142(item, GTGEnchantmentComponents.KEY_STONE);
    }

    static boolean isZRing (class_1799 item) {
        return item.method_31573(GTGItemTags.Z_RINGS)
            || item.method_57824(GTGItemDataComponents.Z_RING) != null
            || class_1890.method_60142(item, GTGEnchantmentComponents.Z_RING);
    }

    static boolean isDynamaxBand (class_1799 item) {
        return item.method_31573(GTGItemTags.DYNAMAX_BANDS)
            || item.method_57824(GTGItemDataComponents.DYNAMAX_BAND) != null
            || class_1890.method_60142(item, GTGEnchantmentComponents.DYNAMAX_BAND);
    }

    static boolean isTeraOrb (class_1799 item) {
        if (item.method_31573(GTGItemTags.BREAKABLE_TERA_ORBS) && item.method_7963() && item.method_7919() == item.method_7936()) return false;

        return item.method_31573(GTGItemTags.TERA_ORBS)
            || item.method_57824(GTGItemDataComponents.TERA_ORB) != null
            || class_1890.method_60142(item, GTGEnchantmentComponents.TERA_ORB);
    }

    static boolean isUnenchantedKeyStone (class_1799 item) {
        return item.method_31573(GTGItemTags.KEY_STONES) || item.method_57824(GTGItemDataComponents.KEY_STONE) != null;
    }
}
