package com.provismet.cobblemon.gimmick.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.provismet.cobblemon.gimmick.api.data.DataItemStack;
import com.provismet.cobblemon.gimmick.api.data.registry.form.FormChangeFusionDataItem;
import com.provismet.cobblemon.gimmick.api.data.registry.HeldItem;
import com.provismet.cobblemon.gimmick.api.data.registry.MegaStone;
import com.provismet.cobblemon.gimmick.api.data.registry.form.FormChangeToggleDataItem;
import com.provismet.cobblemon.gimmick.registry.GTGDynamicRegistryKeys;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import java.util.Optional;

public class GTGGiveCommand {
    public static void register () {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(class_2170.method_9247("gimme-that-gimmick")
                .requires(source -> source.method_9259(2))
                .then(class_2170.method_9247("give")
                    .then(class_2170.method_9244("player", class_2186.method_9305())
                        .then(class_2170.method_9247("fusion_form")
                            .then(class_2170.method_9244("item", class_2232.method_9441())
                                .suggests((context, builder) -> {
                                    registryAccess.method_46762(GTGDynamicRegistryKeys.FUSION)
                                        .method_42017()
                                        .filter(class_6880.class_6883::method_40227)
                                        .forEach(entry -> builder.suggest(entry.method_55840()));

                                    return builder.buildFuture();
                                })
                                .executes(context -> {
                                    class_2960 itemId = class_2232.method_9443(context, "item");
                                    Optional<class_6880.class_6883<FormChangeFusionDataItem>> item = registryAccess
                                        .method_46762(GTGDynamicRegistryKeys.FUSION)
                                        .method_46746(FormChangeFusionDataItem.key(itemId));

                                    if (item.isPresent()) return executeGive(
                                        context,
                                        class_2186.method_9315(context, "player"),
                                        item.get().comp_349(),
                                        1
                                    );

                                    context.getSource().method_9226(() -> class_2561.method_43470("Fusion item " + itemId.toString() + " not found."), false);
                                    return 0;
                                })
                                .then(class_2170.method_9244("count", IntegerArgumentType.integer(1))
                                    .executes(context -> {
                                        class_2960 itemId = class_2232.method_9443(context, "item");
                                        Optional<class_6880.class_6883<FormChangeFusionDataItem>> item = registryAccess
                                            .method_46762(GTGDynamicRegistryKeys.FUSION)
                                            .method_46746(FormChangeFusionDataItem.key(itemId));

                                        if (item.isPresent()) return executeGive(
                                            context,
                                            class_2186.method_9315(context, "player"),
                                            item.get().comp_349(),
                                            IntegerArgumentType.getInteger(context, "count")
                                        );

                                        context.getSource().method_9226(() -> class_2561.method_43470("Fusion item " + itemId.toString() + " not found."), false);
                                        return 0;
                                    })
                                )
                            )
                        )
                        .then(class_2170.method_9247("toggle_form")
                            .then(class_2170.method_9244("item", class_2232.method_9441())
                                .suggests((context, builder) -> {
                                    registryAccess.method_46762(GTGDynamicRegistryKeys.FORM_TOGGLE)
                                        .method_42017()
                                        .filter(class_6880.class_6883::method_40227)
                                        .forEach(entry -> builder.suggest(entry.method_55840()));

                                    return builder.buildFuture();
                                })
                                .executes(context -> {
                                    class_2960 itemId = class_2232.method_9443(context, "item");
                                    Optional<class_6880.class_6883<FormChangeToggleDataItem>> item = registryAccess
                                        .method_46762(GTGDynamicRegistryKeys.FORM_TOGGLE)
                                        .method_46746(FormChangeToggleDataItem.key(itemId));

                                    if (item.isPresent()) return executeGive(
                                        context,
                                        class_2186.method_9315(context, "player"),
                                        item.get().comp_349(),
                                        1
                                    );

                                    context.getSource().method_9226(() -> class_2561.method_43470("Form toggle item " + itemId.toString() + " not found."), false);
                                    return 0;
                                })
                                .then(class_2170.method_9244("count", IntegerArgumentType.integer(1))
                                    .executes(context -> {
                                        class_2960 itemId = class_2232.method_9443(context, "item");
                                        Optional<class_6880.class_6883<FormChangeToggleDataItem>> item = registryAccess
                                            .method_46762(GTGDynamicRegistryKeys.FORM_TOGGLE)
                                            .method_46746(FormChangeToggleDataItem.key(itemId));

                                        if (item.isPresent()) return executeGive(
                                            context,
                                            class_2186.method_9315(context, "player"),
                                            item.get().comp_349(),
                                            IntegerArgumentType.getInteger(context, "count")
                                        );

                                        context.getSource().method_9226(() -> class_2561.method_43470("Form toggle item " + itemId.toString() + " not found."), false);
                                        return 0;
                                    })
                                )
                            )
                        )
                        .then(class_2170.method_9247("megastone")
                            .then(class_2170.method_9244("item", class_2232.method_9441())
                                .suggests((context, builder) -> {
                                    registryAccess.method_46762(GTGDynamicRegistryKeys.MEGASTONE)
                                        .method_42017()
                                        .filter(class_6880.class_6883::method_40227)
                                        .forEach(entry -> builder.suggest(entry.method_55840()));

                                    return builder.buildFuture();
                                })
                                .executes(context -> {
                                    class_2960 itemId = class_2232.method_9443(context, "item");
                                    Optional<class_6880.class_6883<MegaStone>> item = registryAccess
                                        .method_46762(GTGDynamicRegistryKeys.MEGASTONE)
                                        .method_46746(MegaStone.key(itemId));

                                    if (item.isPresent()) return executeGive(
                                        context,
                                        class_2186.method_9315(context, "player"),
                                        item.get().comp_349(),
                                        1
                                    );

                                    context.getSource().method_9226(() -> class_2561.method_43470("MegaStone item " + itemId.toString() + " not found."), false);
                                    return 0;
                                })
                                .then(class_2170.method_9244("count", IntegerArgumentType.integer(1))
                                    .executes(context -> {
                                        class_2960 itemId = class_2232.method_9443(context, "item");
                                        Optional<class_6880.class_6883<MegaStone>> item = registryAccess
                                            .method_46762(GTGDynamicRegistryKeys.MEGASTONE)
                                            .method_46746(MegaStone.key(itemId));

                                        if (item.isPresent()) return executeGive(
                                            context,
                                            class_2186.method_9315(context, "player"),
                                            item.get().comp_349(),
                                            IntegerArgumentType.getInteger(context, "count")
                                        );

                                        context.getSource().method_9226(() -> class_2561.method_43470("MegaStone item " + itemId.toString() + " not found."), false);
                                        return 0;
                                    })
                                )
                            )
                        )
                        .then(class_2170.method_9247("held_item")
                            .then(class_2170.method_9244("item", class_2232.method_9441())
                                .suggests((context, builder) -> {
                                    registryAccess.method_46762(GTGDynamicRegistryKeys.HELD_ITEM)
                                        .method_42017()
                                        .filter(class_6880.class_6883::method_40227)
                                        .forEach(entry -> builder.suggest(entry.method_55840()));

                                    return builder.buildFuture();
                                })
                                .executes(context -> {
                                    class_2960 itemId = class_2232.method_9443(context, "item");
                                    Optional<class_6880.class_6883<HeldItem>> item = registryAccess
                                        .method_46762(GTGDynamicRegistryKeys.HELD_ITEM)
                                        .method_46746(HeldItem.key(itemId));

                                    if (item.isPresent()) return executeGive(
                                        context,
                                        class_2186.method_9315(context, "player"),
                                        item.get().comp_349(),
                                        1
                                    );

                                    context.getSource().method_9226(() -> class_2561.method_43470("Held item " + itemId.toString() + " not found."), false);
                                    return 0;
                                })
                                .then(class_2170.method_9244("count", IntegerArgumentType.integer(1))
                                    .executes(context -> {
                                        class_2960 itemId = class_2232.method_9443(context, "item");
                                        Optional<class_6880.class_6883<HeldItem>> item = registryAccess
                                            .method_46762(GTGDynamicRegistryKeys.HELD_ITEM)
                                            .method_46746(HeldItem.key(itemId));

                                        if (item.isPresent()) return executeGive(
                                            context,
                                            class_2186.method_9315(context, "player"),
                                            item.get().comp_349(),
                                            IntegerArgumentType.getInteger(context, "count")
                                        );

                                        context.getSource().method_9226(() -> class_2561.method_43470("Held item " + itemId.toString() + " not found."), false);
                                        return 0;
                                    })
                                )
                            )
                        )
                    )
                )
            );
        });
    }

    private static int executeGive (CommandContext<class_2168> context, class_3222 player, DataItemStack item, int count) {
        class_1799 stack = item.create();
        if (stack == null) {
            context.getSource().method_9226(() -> class_2561.method_43470("Failed to generate requested item, the data may be malformed."), false);
            return 0;
        }

        for (int i = 0; i < count; ++i) {
            player.method_7270(stack);
        }
        context.getSource().method_9226(() -> class_2561.method_43470("Gave " + count + " ").method_27693(item.name()).method_27693(" to ").method_10852(player.method_5477()), false);
        return 1;
    }
}