package com.provismet.cobblemon.gimmick.datagen;

import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.provismet.cobblemon.gimmick.api.data.registry.form.BattleForm;
import com.provismet.cobblemon.gimmick.api.data.registry.form.BattleForm.PokemonTransformation;
import com.provismet.cobblemon.gimmick.api.data.PokemonFeatures;
import com.provismet.cobblemon.gimmick.api.datagen.BattleFormProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class BattleFormGenerator extends BattleFormProvider {
    public BattleFormGenerator (FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void generate (class_7225.class_7874 wrapperLookup, BiConsumer<class_2960, BattleForm> consumer) {
        this.createBasic(consumer, "aegislash", "stance_forme", "shield", "blade");
        this.createComplex(consumer,
            "castform",
            PokemonFeatures.single("forecast_form", "normal"),
            Map.of(
                "sunny", PokemonFeatures.single("forecast_form", "sunny"),
                "rainy", PokemonFeatures.single("forecast_form", "rainy"),
                "snowy", PokemonFeatures.single("forecast_form", "snowy")
            )
        );
        this.createComplex(consumer,
            "cramorant",
            PokemonFeatures.single("missile_form", "none"),
            Map.of(
                "gulping", PokemonFeatures.single("missile_form", "gulping"),
                "gorging", PokemonFeatures.single("missile_form", "gorging")
            )
        );
        this.createBasic(consumer, "cherrim", "blossom_form", "overcast", "sunshine");
        this.createComplex(consumer,
            "darmanitan",
            PokemonFeatures.single("blazing_mode", "standard"),
            Map.of(
                "zen", PokemonFeatures.single("blazing_mode", "zen"),
                "", PokemonFeatures.single("blazing_mode", "standard") // Happens if HP goes back above 50%.
            )
        );
        this.createComplex(consumer,
            "eiscue",
            PokemonFeatures.single("penguin_head", "ice_face"),
            Map.of("noice", PokemonFeatures.single("penguin_head", "noice_face"))
        );
        this.createBasic(consumer, "meloetta", "song_forme", "aria", "pirouette");
        this.createBasic(consumer, "mimikyu", "disguise_form", "disguised", "busted");
        this.createBasic(consumer, "minior", "meteor_shield", "shield", "meteor");
        this.createBasic(consumer, "morpeko", "hunger_mode", "full_belly", "hangry");
        this.createBasic(consumer, "palafin", "dolphin_form", "zero", "hero");
        this.createBasic(consumer, "wishiwashi", "schooling_form", "solo", "school");
        this.createBasic(consumer, "xerneas", "life_mode", "neutral", "active");
    }

    private void createBasic (BiConsumer<class_2960, BattleForm> consumer, String speciesId, String featureName, String defaultValue, String formValue) {
        class_2960 pokemonId = MiscUtilsKt.cobblemonResource(speciesId);
        consumer.accept(
            pokemonId,
            new BattleForm(
                PokemonTransformation.of(PokemonFeatures.single(featureName, defaultValue), pokemonId.method_48331("_base")),
                Map.of(formValue, PokemonTransformation.of(PokemonFeatures.single(featureName, formValue), pokemonId.method_48331("_" + formValue)))
            )
        );
    }

    private void createComplex (BiConsumer<class_2960, BattleForm> consumer, String speciesId, PokemonFeatures defaultForm, Map<String, PokemonFeatures> alternateForms) {
        class_2960 pokemonId = MiscUtilsKt.cobblemonResource(speciesId);
        consumer.accept(
            pokemonId,
            new BattleForm(
                PokemonTransformation.of(defaultForm, pokemonId.method_48331("_base")),
                alternateForms.entrySet()
                    .stream()
                    .collect(Collectors.toMap(Map.Entry::getKey, val -> PokemonTransformation.of(val.getValue(), pokemonId.method_48331("_" + val.getKey()))))
            )
        );
    }
}
