package com.provismet.cobblemon.gimmick.datagen.debug;

import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.api.data.particle.SnowstormEffect;
import com.provismet.cobblemon.gimmick.api.data.particle.VanillaParticleEffect;
import com.provismet.cobblemon.gimmick.api.data.particle.VanillaParticleEffect.VanillaParticleLayer;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.api.datagen.EffectsDataProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_7225;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class DebugEffectsGenerator extends EffectsDataProvider {
    public DebugEffectsGenerator (FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void generate (class_7225.class_7874 wrapperLookup, BiConsumer<class_2960, EffectsData> consumer) {
        consumer.accept(
            GimmeThatGimmickMain.identifier("fake_snowstorm"),
            new EffectsData(
                Optional.of(new SnowstormEffect(MiscUtilsKt.cobblemonResource("fake_snowstorm"), List.of("target"), Optional.empty())),
                Optional.of("cry"),
                Optional.of(2f),
                Optional.of(class_3417.field_26980)
            )
        );

        consumer.accept(
            GimmeThatGimmickMain.identifier("layered_vanilla"),
            new EffectsData(
                Optional.of(new VanillaParticleEffect(
                    List.of(
                        new VanillaParticleLayer(class_2398.field_11204, 10, 4),
                        new VanillaParticleLayer(class_2398.field_11211, 10, 1)
                    )
                )),
                Optional.of("cry"),
                Optional.empty(),
                Optional.of(class_3417.field_14703)
            )
        );

        consumer.accept(
            GimmeThatGimmickMain.identifier("mega_evolution"),
            new EffectsData(
                Optional.of(new VanillaParticleEffect(
                    List.of(
                        new VanillaParticleLayer(class_2398.field_11201, 3, 1),
                        new VanillaParticleLayer(class_2398.field_11205, 50, 3)
                    )
                )),
                Optional.of("cry"),
                Optional.of(2.5f),
                Optional.of(class_3417.field_14931)
            )
        );
    }
}
