package com.provismet.cobblemon.gimmick.datagen.debug;

import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.api.data.component.DataItem;
import com.provismet.cobblemon.gimmick.api.data.component.FormToggle;
import com.provismet.cobblemon.gimmick.api.data.PokemonFeatures;
import com.provismet.cobblemon.gimmick.api.data.PokemonRequirements;
import com.provismet.cobblemon.gimmick.api.data.registry.form.FormChangeToggleDataItem;
import com.provismet.cobblemon.gimmick.api.datagen.FormChangeToggleItemProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class DebugFormToggleGenerator extends FormChangeToggleItemProvider {
    public DebugFormToggleGenerator (FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void generate (class_7225.class_7874 wrapperLookup, BiConsumer<class_2960, FormChangeToggleDataItem> consumer) {
        consumer.accept(
            GimmeThatGimmickMain.identifier("become_alolan"),
            new FormChangeToggleDataItem(
                new DataItem(
                    "The Alolanator",
                    List.of("Sends your pokemon on vacation."),
                    class_7923.field_41178.method_10221(class_1802.field_8145),
                    Optional.empty(),
                    class_1814.field_8907
                ),
                new FormToggle(
                    new PokemonRequirements(
                        List.of(
                            "raichu",
                            "muk",
                            "grimer",
                            "vulpix",
                            "ninetales",
                            "rattata",
                            "raticate",
                            "sandshrew",
                            "sandslash",
                            "diglet",
                            "dugtrio",
                            "meowth",
                            "persian",
                            "geodude",
                            "graveler",
                            "golem",
                            "exeggutor",
                            "marowak"
                        ),
                        List.of("normal", "alola"),
                        List.of(),
                        List.of(),
                        List.of(),
                        List.of()
                    ),
                    new PokemonRequirements(
                        List.of(),
                        List.of("normal"),
                        List.of(),
                        List.of(),
                        List.of(),
                        List.of()
                    ),
                    PokemonFeatures.single("alolan", true),
                    PokemonFeatures.single("alolan", false),
                    Optional.of(GimmeThatGimmickMain.identifier("layered_vanilla"))
                )
            )
        );
    }
}
